/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.validation;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import org.jboss.solder.beanManager.BeanManagerAware;

public class InjectingConstraintValidatorFactory
extends BeanManagerAware
implements ConstraintValidatorFactory {
    private final ConstraintValidatorFactory delegate = Validation.byDefaultProvider().configure().getDefaultConstraintValidatorFactory();

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        ConstraintValidator theValue;
        if (!this.isBeanManagerAvailable()) {
            throw new IllegalStateException("No bean manager is available. In order to use InjectingConstraintValidatorFactory, the javax.validation.Validator must either be retrieved via dependency injection or a bean manager must be available via JNDI.");
        }
        BeanManager beanManager = this.getBeanManager();
        Set beans = beanManager.getBeans(key, new Annotation[0]);
        if (!beans.isEmpty()) {
            Bean bean = beanManager.resolve(beans);
            CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            theValue = (ConstraintValidator)beanManager.getReference(bean, key, ctx);
        } else {
            theValue = this.delegate.getInstance(key);
        }
        return (T)theValue;
    }
}

