/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.Collection;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.NonTransitiveStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionContainer;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenStrategyStageBaseImpl<STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
implements MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>,
MavenWorkingSessionContainer {
    private final MavenWorkingSession session;

    public MavenStrategyStageBaseImpl(MavenWorkingSession session) {
        this.session = session;
    }

    public FORMATSTAGETYPE withTransitivity() {
        return this.using((MavenResolutionStrategy)TransitiveStrategy.INSTANCE);
    }

    public FORMATSTAGETYPE withoutTransitivity() {
        return this.using((MavenResolutionStrategy)NonTransitiveStrategy.INSTANCE);
    }

    @Override
    public MavenWorkingSession getMavenWorkingSession() {
        return this.session;
    }

    public FORMATSTAGETYPE using(MavenResolutionStrategy strategy) throws IllegalArgumentException {
        Validate.notEmpty(this.session.getDependenciesForResolution(), "No dependencies were set for resolution");
        Collection resolvedArtifacts = this.session.resolveDependencies(strategy);
        return this.createFormatStage(resolvedArtifacts);
    }

    public STRATEGYSTAGETYPE withClassPathResolution(boolean useClassPathResolution) {
        if (!useClassPathResolution) {
            this.session.disableClassPathWorkspaceReader();
        }
        return this.covarientReturn();
    }

    public STRATEGYSTAGETYPE withMavenCentralRepo(boolean useMavenCentral) {
        if (!useMavenCentral) {
            this.session.disableMavenCentral();
        }
        return this.covarientReturn();
    }

    private STRATEGYSTAGETYPE covarientReturn() {
        return (STRATEGYSTAGETYPE)((MavenStrategyStageBase)this.getActualClass().cast(this));
    }

    protected abstract Class<STRATEGYSTAGETYPE> getActualClass();

    protected abstract FORMATSTAGETYPE createFormatStage(Collection<MavenResolvedArtifact> var1);
}

