/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.shrinkwrap.resolver.api.maven.MavenVersionRangeResult;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;

public class MavenVersionRangeResultImpl
implements MavenVersionRangeResult {
    private final Artifact artifact;
    private final VersionRangeResult versionRangeResult;
    private List<MavenCoordinate> versions;

    public MavenVersionRangeResultImpl(Artifact artifact, VersionRangeResult versionRangeResult) {
        this.artifact = artifact;
        this.versionRangeResult = versionRangeResult;
    }

    public MavenCoordinate getLowestVersion() {
        return this.getCoordinate(this.versionRangeResult.getLowestVersion());
    }

    public MavenCoordinate getHighestVersion() {
        return this.getCoordinate(this.versionRangeResult.getHighestVersion());
    }

    public List<MavenCoordinate> getVersions() {
        if (this.versions == null) {
            List versions = this.versionRangeResult.getVersions();
            ArrayList<MavenCoordinate> coordinates = new ArrayList<MavenCoordinate>(versions.size());
            for (Version version : versions) {
                coordinates.add(this.getCoordinate(version));
            }
            this.versions = Collections.unmodifiableList(coordinates);
        }
        return this.versions;
    }

    private MavenCoordinate getCoordinate(Version version) {
        if (version == null) {
            return null;
        }
        return MavenCoordinates.createCoordinate((String)this.artifact.getGroupId(), (String)this.artifact.getArtifactId(), (String)version.toString(), (PackagingType)PackagingType.of((String)this.artifact.getExtension()), (String)this.artifact.getClassifier());
    }

    public String toString() {
        StringBuilder versionsBuilder = new StringBuilder("{");
        boolean first = true;
        for (MavenCoordinate version : this.getVersions()) {
            if (first) {
                first = false;
            } else {
                versionsBuilder.append(',');
            }
            versionsBuilder.append(version.getVersion());
        }
        versionsBuilder.append("}");
        return "MavenResolvedVersionsImpl[artifact=" + this.artifact + ", versions=" + versionsBuilder + ']';
    }
}

