/*
 * Copyright (c) 2000, 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package org.jboss.com.sun.corba.se.impl.ior;

import java.util.Arrays;
import java.util.Iterator;

public class ObjectAdapterIdArray extends ObjectAdapterIdBase
{
    private final String[] objectAdapterId;

    public ObjectAdapterIdArray(String[] objectAdapterId)
    {
        this.objectAdapterId = objectAdapterId;
    }

    /**
     * Special constructor used for OA IDs of length 2.
     */
    public ObjectAdapterIdArray(String name1, String name2)
    {
        objectAdapterId = new String[2];
        objectAdapterId[0] = name1;
        objectAdapterId[1] = name2;
    }

    public int getNumLevels()
    {
        return objectAdapterId.length;
    }

    public Iterator<String> iterator()
    {
        return Arrays.asList(objectAdapterId).iterator();
    }

    public String[] getAdapterName()
    {
        return objectAdapterId.clone();
    }
}
