/*
 * Copyright (c) 2002, 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package org.jboss.com.sun.corba.se.spi.ior;

/**
 * TaggedProfile represents a tagged profile in an IOR. A profile contains all of the information necessary for an
 * invocation. It contains one or more endpoints that may be used for an invocation. A TaggedProfile conceptually has
 * three parts: A TaggedProfileTemplate, an ObjectKeyTemplate, and an ObjectId.
 */
public interface TaggedProfile extends Identifiable, MakeImmutable
{
    TaggedProfileTemplate getTaggedProfileTemplate();

    ObjectId getObjectId();

    ObjectKeyTemplate getObjectKeyTemplate();

    ObjectKey getObjectKey();

    /**
     * Return true is prof is equivalent to this TaggedProfile. This means that this and prof are indistinguishable for
     * the purposes of remote invocation. Typically this means that the profile data is identical and both profiles
     * contain exactly the same components (if components are applicable). isEquivalent( prof ) should imply that
     * getObjectId().equals( prof.getObjectId() ) is true, and so is getObjectKeyTemplate().equals(
     * prof.getObjectKeyTemplate() ).
     */
    boolean isEquivalent(TaggedProfile prof);

    /**
     * Return the TaggedProfile as a CDR encapsulation in the standard format. This is required for Portable
     * interceptors.
     */
    org.omg.IOP.TaggedProfile getIOPProfile();

    /**
     * Return true if this TaggedProfile was created in orb. Caches the result.
     */
    boolean isLocal();
}
