/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.stub.faces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.jboss.test.faces.stub.faces.StubFacesContextFactory;
import org.jboss.test.faces.stub.faces.StubRenderKit;

public class StubFacesContext
extends FacesContext {
    private Application application;
    private UIViewRoot viewRoot;
    private final Map<String, List<FacesMessage>> messages = new LinkedHashMap<String, List<FacesMessage>>();
    private Map<Object, Object> attributes = new HashMap<Object, Object>();
    private ExternalContext externalContext;
    private ResponseWriter responseWriter;
    private RenderKitFactory renderKitFactory;
    private ELContext elContext;
    private boolean renderResponse;
    private boolean responseComplete;
    private PhaseId currentPhaseId;
    private boolean postback;

    public StubFacesContext() {
        this.attributes.put("javax.faces.SEPARATOR_CHAR", Character.valueOf(':'));
    }

    public StubFacesContext(boolean postback) {
        this();
        this.postback = postback;
    }

    public StubFacesContext(Application application) {
        this();
        this.application = application;
    }

    public StubFacesContext(Application application, boolean postback) {
        this();
        this.application = application;
        this.postback = postback;
    }

    public StubFacesContext(ExternalContext externalContext, Application application) {
        this();
        this.externalContext = externalContext;
        this.application = application;
    }

    public StubFacesContext(ExternalContext externalContext) {
        this();
        this.application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this.renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.externalContext = externalContext;
    }

    public Application getApplication() {
        return this.application;
    }

    public Iterator getClientIdsWithMessages() {
        return this.messages.keySet().iterator();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        FacesMessage.Severity max = null;
        for (List<FacesMessage> messagesForKey : this.messages.values()) {
            for (FacesMessage msg : messagesForKey) {
                if (msg.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                    return FacesMessage.SEVERITY_FATAL;
                }
                if (max != null && msg.getSeverity().compareTo((Object)max) <= 0) continue;
                max = msg.getSeverity();
            }
        }
        return max;
    }

    public Iterator getMessages() {
        return this.messages.size() > 0 ? new FacesMessagesIterator(this.messages) : Collections.emptyList().iterator();
    }

    public Iterator getMessages(String clientId) {
        List<FacesMessage> messagesForKey = this.messages.get(clientId);
        return messagesForKey != null ? messagesForKey.iterator() : Collections.emptyList().iterator();
    }

    public List<FacesMessage> getMessageList() {
        ArrayList<FacesMessage> aggregatedMessages = new ArrayList<FacesMessage>();
        for (List<FacesMessage> messagesForKey : this.messages.values()) {
            aggregatedMessages.addAll(messagesForKey);
        }
        return Collections.unmodifiableList(aggregatedMessages);
    }

    public List<FacesMessage> getMessageList(String clientId) {
        return this.messages.containsKey(clientId) ? Collections.unmodifiableList(this.messages.get(clientId)) : Collections.emptyList();
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public RenderKit getRenderKit() {
        if (this.getViewRoot() == null || this.getViewRoot().getRenderKitId() == null) {
            return StubRenderKit.INSTANCE;
        }
        return this.renderKitFactory.getRenderKit((FacesContext)this, this.getViewRoot().getRenderKitId());
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        throw new UnsupportedOperationException();
    }

    public void setResponseStream(ResponseStream stream) {
        throw new UnsupportedOperationException();
    }

    public ResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter writer) {
        this.responseWriter = writer;
    }

    public UIViewRoot getViewRoot() {
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot vr) {
        this.viewRoot = vr;
    }

    public void addMessage(String clientId, FacesMessage msg) {
        if (!this.messages.containsKey(clientId)) {
            ArrayList<FacesMessage> messagesForKey = new ArrayList<FacesMessage>(1);
            messagesForKey.add(msg);
            this.messages.put(clientId, messagesForKey);
        } else {
            this.messages.get(clientId).add(msg);
        }
    }

    public void release() {
        StubFacesContext.setCurrentInstance(null);
        StubFacesContextFactory.setFacesContext(null);
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }

    public PhaseId getCurrentPhaseId() {
        return this.currentPhaseId;
    }

    public void setCurrentPhaseId(PhaseId phaseId) {
        this.currentPhaseId = phaseId;
    }

    public boolean isPostback() {
        return this.postback;
    }

    public void setPostback(boolean postback) {
        this.postback = postback;
    }

    public StubFacesContext setCurrent() {
        StubFacesContext.setCurrentInstance((FacesContext)this);
        StubFacesContextFactory.setFacesContext(this);
        return this;
    }

    public StubFacesContext createViewRoot() {
        this.viewRoot = new UIViewRoot();
        this.viewRoot.setRenderKitId(this.getApplication().getViewHandler().calculateRenderKitId((FacesContext)this));
        return this;
    }

    public ELContext getELContext() {
        return this.elContext;
    }

    public void setELContext(ELContext elContext) {
        this.elContext = elContext;
    }

    private static final class FacesMessagesIterator
    implements Iterator<FacesMessage> {
        private Map<String, List<FacesMessage>> messages;
        private int keyIndex = -1;
        private int numKeys;
        private Iterator<FacesMessage> messagesForKey;
        private Iterator<String> keys;

        FacesMessagesIterator(Map<String, List<FacesMessage>> messages) {
            this.messages = messages;
            this.numKeys = messages.size();
            this.keys = messages.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.keyIndex == -1) {
                ++this.keyIndex;
                this.messagesForKey = this.messages.get(this.keys.next()).iterator();
            }
            while (!this.messagesForKey.hasNext()) {
                ++this.keyIndex;
                if (this.keyIndex < this.numKeys) {
                    this.messagesForKey = this.messages.get(this.keys.next()).iterator();
                    continue;
                }
                return false;
            }
            return this.messagesForKey.hasNext();
        }

        @Override
        public FacesMessage next() {
            if (this.keyIndex >= this.numKeys) {
                throw new NoSuchElementException();
            }
            if (this.messagesForKey != null && this.messagesForKey.hasNext()) {
                return this.messagesForKey.next();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.messagesForKey.next();
        }

        @Override
        public void remove() {
            if (this.keyIndex == -1) {
                throw new IllegalStateException();
            }
            this.messagesForKey.remove();
        }
    }
}

