/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.framework;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.HttpCommandProcessor;
import java.net.URL;
import org.jboss.test.selenium.browser.Browser;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.ExtendedSelenium;
import org.jboss.test.selenium.framework.ExtendedTypedSeleniumImpl;
import org.jboss.test.selenium.framework.internal.PageExtensions;
import org.jboss.test.selenium.framework.internal.SeleniumExtensions;
import org.jboss.test.selenium.interception.InterceptionProxy;
import org.jboss.test.selenium.request.RequestInterceptor;

public class AjaxSeleniumImpl
extends ExtendedTypedSeleniumImpl
implements AjaxSelenium {
    PageExtensions pageExtensions;
    SeleniumExtensions seleniumExtensions;
    RequestInterceptor requestInterceptor;
    InterceptionProxy interceptionProxy;

    private AjaxSeleniumImpl() {
    }

    public AjaxSeleniumImpl(String serverHost, int serverPort, Browser browser, URL contextPathURL) {
        HttpCommandProcessor commandProcessor = new HttpCommandProcessor(serverHost, serverPort, browser.getAsString(), contextPathURL.toString());
        this.interceptionProxy = new InterceptionProxy((CommandProcessor)commandProcessor);
        this.selenium = new ExtendedSelenium(this.interceptionProxy.getCommandProcessorProxy());
        this.pageExtensions = new PageExtensions();
        this.seleniumExtensions = new SeleniumExtensions();
        this.requestInterceptor = new RequestInterceptor();
    }

    @Override
    public PageExtensions getPageExtensions() {
        return this.pageExtensions;
    }

    @Override
    public SeleniumExtensions getSeleniumExtensions() {
        return this.seleniumExtensions;
    }

    @Override
    public RequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    @Override
    public InterceptionProxy getInterceptionProxy() {
        return this.interceptionProxy;
    }

    @Override
    public AjaxSelenium clone() throws CloneNotSupportedException {
        AjaxSeleniumImpl copy = new AjaxSeleniumImpl();
        copy.pageExtensions = new PageExtensions();
        copy.seleniumExtensions = new SeleniumExtensions();
        copy.interceptionProxy = this.interceptionProxy.immutableCopy();
        copy.selenium = new ExtendedSelenium(copy.interceptionProxy.getCommandProcessorProxy());
        return copy;
    }
}

