/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.guard.request;

import com.thoughtworks.selenium.SeleniumException;
import org.jboss.test.selenium.SystemProperties;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.guard.GuardedCommands;
import org.jboss.test.selenium.guard.request.RequestTypeGuardException;
import org.jboss.test.selenium.interception.CommandContext;
import org.jboss.test.selenium.interception.CommandInterceptionException;
import org.jboss.test.selenium.interception.CommandInterceptor;
import org.jboss.test.selenium.request.RequestType;

public class RequestTypeGuard
implements CommandInterceptor {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private RequestType requestExpected;
    private boolean interlayed;

    public RequestTypeGuard(RequestType requestExpected, boolean interlayed) {
        this.requestExpected = requestExpected;
        this.interlayed = interlayed;
    }

    @Override
    public void intercept(CommandContext ctx) throws CommandInterceptionException {
        String command = ctx.getCommand();
        if (GuardedCommands.INTERACTIVE_COMMANDS.contains(command) || command.equals("getEval")) {
            this.doBeforeCommand();
        }
        ctx.invoke();
        if (GuardedCommands.INTERACTIVE_COMMANDS.contains(command) || command.equals("getEval")) {
            this.doAfterCommand();
        }
    }

    public void doBeforeCommand() {
        this.selenium.getPageExtensions().install();
        this.selenium.getRequestInterceptor().clearRequestTypeDone();
    }

    public void doAfterCommand() {
        long end = System.currentTimeMillis() + SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.AJAX);
        RequestType lastRequestDone = RequestType.NONE;
        while (System.currentTimeMillis() <= end) {
            try {
                this.selenium.getRequestInterceptor().waitForRequestTypeChange();
            }
            catch (SeleniumException e) {
                // empty catch block
            }
            RequestType requestDone = this.selenium.getRequestInterceptor().clearRequestTypeDone();
            if (requestDone == this.requestExpected) {
                lastRequestDone = requestDone;
                break;
            }
            if (this.interlayed) {
                if (requestDone == RequestType.HTTP) {
                    this.selenium.getPageExtensions().install();
                    this.selenium.getRequestInterceptor().clearRequestTypeDone();
                }
                if (requestDone == RequestType.NONE) continue;
                lastRequestDone = requestDone;
                continue;
            }
            lastRequestDone = requestDone;
            break;
        }
        if (lastRequestDone != this.requestExpected) {
            throw new RequestTypeGuardException(this.requestExpected, lastRequestDone);
        }
    }
}

