/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.locator;

import org.jboss.test.selenium.locator.AbstractElementLocator;
import org.jboss.test.selenium.locator.ElementLocationStrategy;
import org.jboss.test.selenium.locator.ExtendedLocator;
import org.jboss.test.selenium.locator.LocatorFactory;
import org.jboss.test.selenium.locator.iteration.ChildElementList;
import org.jboss.test.selenium.locator.iteration.ElementOcurrenceList;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class XpathLocator
extends AbstractElementLocator<XpathLocator>
implements ExtendedLocator<XpathLocator> {
    public XpathLocator(String xpath) {
        super(xpath);
    }

    @Override
    public ElementLocationStrategy getLocationStrategy() {
        return ElementLocationStrategy.XPATH;
    }

    @Override
    public XpathLocator getNthChildElement(int index) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public XpathLocator getNthOccurence(int index) {
        return new XpathLocator(SimplifiedFormat.format("getLocator[{0}]", index - 1));
    }

    @Override
    public Iterable<XpathLocator> getAllChildren() {
        return new ChildElementList<XpathLocator>(this.getChild(LocatorFactory.xp("*")));
    }

    @Override
    public Iterable<XpathLocator> getAllOccurrences() {
        return new ElementOcurrenceList<XpathLocator>(this);
    }

    @Override
    public Iterable<XpathLocator> getChildren(XpathLocator elementLocator) {
        return new ChildElementList<XpathLocator>(this.getChild(elementLocator));
    }

    @Override
    public Iterable<XpathLocator> getDescendants(XpathLocator elementLocator) {
        return new ElementOcurrenceList<XpathLocator>(this);
    }

    @Override
    public XpathLocator getChild(XpathLocator elementLocator) {
        return new XpathLocator(SimplifiedFormat.format("{0}/{1}", this.getRawLocator(), elementLocator.getRawLocator()));
    }

    @Override
    public XpathLocator getDescendant(XpathLocator elementLocator) {
        return new XpathLocator(SimplifiedFormat.format("{0}//{1}", this.getRawLocator(), elementLocator.getRawLocator()));
    }

    @Override
    public ExtendedLocator<XpathLocator> format(Object ... args) {
        return (ExtendedLocator)super.format(args);
    }
}

