/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.conditions;

import com.thoughtworks.selenium.SeleniumException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;

public class AlertEquals
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private String message;

    protected AlertEquals() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull((Object)this.message);
        if (!this.selenium.isAlertPresent()) {
            return false;
        }
        String alertMessage = this.selenium.getAlert();
        if (!this.message.equals(alertMessage)) {
            throw new SeleniumException(SimplifiedFormat.format("Alert has been displayed, but the message '{0}' doesn't equal to the expected '{1}'", this.message, alertMessage));
        }
        return true;
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        Validate.notNull((Object)this.message);
        String escapedMessage = StringEscapeUtils.escapeJavaScript((String)this.message);
        return JavaScript.js(SimplifiedFormat.format("selenium.isAlertPresent() && ((alertMessage = selenium.getAlert()) == '{0}' || selenium.throwError('Alert has been displayed, but the message \\'' + alertMessage + '\\' doesn\\'t equal to the expected \\'{0}\\''))", escapedMessage));
    }

    public static AlertEquals getInstance() {
        return new AlertEquals();
    }

    public AlertEquals message(String message) {
        Validate.notNull((Object)message);
        AlertEquals copy = this.copy();
        copy.message = message;
        return copy;
    }

    private AlertEquals copy() {
        AlertEquals copy = new AlertEquals();
        copy.message = this.message;
        return copy;
    }
}

