/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.ElementLocationStrategy;
import org.jboss.test.selenium.locator.IterableLocator;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;

public class CountEquals
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private IterableLocator<?> iterableLocator;
    private Integer count;

    protected CountEquals() {
    }

    @Override
    public boolean isTrue() {
        this.validate();
        return this.selenium.getCount(this.iterableLocator) == this.count.intValue();
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        this.validate();
        String escapedRawLocator = StringEscapeUtils.escapeJavaScript((String)this.iterableLocator.getRawLocator());
        String countFunction = this.iterableLocator.getLocationStrategy() == ElementLocationStrategy.JQUERY ? "getJQueryCount" : "getXPathCount";
        return JavaScript.js("selenium.{0}('{1}') == {2}").parametrize(countFunction, escapedRawLocator, this.count);
    }

    private void validate() {
        Validate.notNull(this.iterableLocator);
        Validate.notNull((Object)this.count);
    }

    public static CountEquals getInstance() {
        return new CountEquals();
    }

    public CountEquals locator(IterableLocator<?> iterableLocator) {
        Validate.notNull(iterableLocator);
        if (iterableLocator.getLocationStrategy() != ElementLocationStrategy.JQUERY && iterableLocator.getLocationStrategy() != ElementLocationStrategy.XPATH) {
            throw new IllegalArgumentException("Only XPath and JQuery locators are supported for counting");
        }
        CountEquals copy = this.copy();
        copy.iterableLocator = iterableLocator;
        return copy;
    }

    public CountEquals count(int count) {
        Validate.notNull((Object)count);
        CountEquals copy = this.copy();
        copy.count = count;
        return copy;
    }

    private CountEquals copy() {
        CountEquals copy = new CountEquals();
        copy.iterableLocator = this.iterableLocator;
        copy.count = this.count;
        return copy;
    }
}

