/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;

public class IsDisplayed
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private ElementLocator<?> elementLocator;

    protected IsDisplayed() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.elementLocator);
        return this.selenium.isDisplayed(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.getAsString());
        return JavaScript.js(SimplifiedFormat.format("selenium.isDisplayed('{0}')", escapedLocator));
    }

    public static IsDisplayed getInstance() {
        return new IsDisplayed();
    }

    public IsDisplayed locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        IsDisplayed copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private IsDisplayed copy() {
        IsDisplayed copy = new IsDisplayed();
        copy.elementLocator = this.elementLocator;
        return copy;
    }
}

