/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.logging.CommonLogger;

public class FileSystemBeanArchiveHandler
implements BeanArchiveHandler {
    private static final Logger log = Logger.getLogger(FileSystemBeanArchiveHandler.class);
    public static final String CLASS_FILE_EXTENSION = ".class";

    @Override
    public BeanArchiveBuilder handle(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        BeanArchiveBuilder builder = new BeanArchiveBuilder();
        try {
            log.debugv("Handle path: {0}", (Object)path);
            if (file.isDirectory()) {
                this.handleDirectory(new DirectoryEntry().setFile(file), builder);
            } else {
                this.handleFile(file, builder);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Could not handle path: " + path), (Throwable)e);
        }
        return builder;
    }

    protected void handleFile(File file, BeanArchiveBuilder builder) throws IOException {
        log.debugv("Handle archive file: {0}", (Object)file);
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            ZipFileEntry entry = new ZipFileEntry("jar:" + file.toURI().toURL().toExternalForm() + "!/");
            while (entries.hasMoreElements()) {
                this.add(entry.setName(entries.nextElement().getName()), builder);
            }
            zip.close();
        }
        catch (ZipException e) {
            throw CommonLogger.LOG.cannotHandleFile(file, e);
        }
    }

    protected void handleDirectory(DirectoryEntry entry, BeanArchiveBuilder builder) throws IOException {
        log.debugv("Handle directory: {0}", (Object)entry.getFile());
        File[] files = entry.getFile().listFiles();
        if (files == null) {
            log.warnv("Unable to list directory files: {0}", (Object)entry.getFile());
        }
        String parentPath = entry.getName();
        for (File child : files) {
            if (entry.getName() != null) {
                entry.setPath(entry.getName() + "/" + child.getName());
            } else {
                entry.setPath(child.getName());
            }
            entry.setFile(child);
            if (child.isDirectory()) {
                this.handleDirectory(entry, builder);
            } else {
                this.add(entry, builder);
            }
            entry.setPath(parentPath);
        }
    }

    protected void add(Entry entry, BeanArchiveBuilder builder) throws MalformedURLException {
        if (this.isClass(entry.getName())) {
            builder.addClass(this.filenameToClassname(entry.getName()));
        }
    }

    protected boolean isClass(String name) {
        return name.endsWith(CLASS_FILE_EXTENSION);
    }

    private String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(CLASS_FILE_EXTENSION)).replace('/', '.').replace('\\', '.');
    }

    private static class DirectoryEntry
    implements Entry {
        private String path;
        private File file;

        private DirectoryEntry() {
        }

        @Override
        public String getName() {
            return this.path;
        }

        @Override
        public URL getUrl() throws MalformedURLException {
            return this.file.toURI().toURL();
        }

        public DirectoryEntry setPath(String path) {
            this.path = path;
            return this;
        }

        public File getFile() {
            return this.file;
        }

        public DirectoryEntry setFile(File dir) {
            this.file = dir;
            return this;
        }
    }

    private static class ZipFileEntry
    implements Entry {
        private String name;
        private String archiveUrl;

        ZipFileEntry(String archiveUrl) {
            this.archiveUrl = archiveUrl;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public URL getUrl() throws MalformedURLException {
            return new URL(this.archiveUrl + this.name);
        }

        ZipFileEntry setName(String name) {
            this.name = name;
            return this;
        }
    }

    protected static interface Entry {
        public String getName();

        public URL getUrl() throws MalformedURLException;
    }
}

