/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.environment.se.discovery.ImmutableBeanDeploymentArchive;
import org.jboss.weld.environment.se.discovery.url.ClasspathScanningException;
import org.jboss.weld.environment.se.discovery.url.FileSystemURLHandler;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLScanner {
    private static final Logger log = LoggerFactory.getLogger(URLScanner.class);
    private final String[] resources;
    private final ResourceLoader resourceLoader;
    private final Bootstrap bootstrap;

    public URLScanner(ResourceLoader resourceLoader, Bootstrap bootstrap, String ... resources) {
        this.resources = resources;
        this.resourceLoader = resourceLoader;
        this.bootstrap = bootstrap;
    }

    public BeanDeploymentArchive scan() {
        FileSystemURLHandler handler = new FileSystemURLHandler();
        ArrayList<String> discoveredClasses = new ArrayList<String>();
        ArrayList<URL> discoveredBeanXmlUrls = new ArrayList<URL>();
        ArrayList<String> paths = new ArrayList<String>();
        for (String resourceName : this.resources) {
            Collection<URL> urlEnum = this.resourceLoader.getResources(resourceName);
            for (URL url : urlEnum) {
                String urlPath = url.toExternalForm();
                String urlType = "file";
                int colonIndex = urlPath.indexOf(":");
                if (colonIndex != -1) {
                    urlType = urlPath.substring(0, colonIndex);
                }
                if ("file".equals(urlType) || "jar".equals(urlType)) {
                    urlPath = url.getPath();
                    if (urlPath.indexOf(33) > 0) {
                        urlPath = urlPath.substring(0, urlPath.indexOf(33));
                    } else {
                        File dirOrArchive = new File(urlPath);
                        if (resourceName != null && resourceName.lastIndexOf(47) > 0) {
                            dirOrArchive = dirOrArchive.getParentFile();
                        }
                        urlPath = dirOrArchive.getParent();
                    }
                }
                try {
                    urlPath = URLDecoder.decode(urlPath, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new ClasspathScanningException("Error decoding URL using UTF-8");
                }
                log.debug("URL Type: " + urlType);
                paths.add(urlPath);
            }
            handler.handle(paths, discoveredClasses, discoveredBeanXmlUrls);
        }
        return new ImmutableBeanDeploymentArchive("classpath", discoveredClasses, this.bootstrap.parse(discoveredBeanXmlUrls));
    }
}

