/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionTargetValidator
implements Service {
    private final Validator validator = new Validator();
    private final Collection<InjectionTarget<?>> injectionTargets = new ArrayList();
    private final Container container = Container.instance();
    private final BeanManagerImpl beanManager;

    public InjectionTargetValidator(BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
    }

    public void addInjectionTarget(InjectionTarget<?> injectionTarget) {
        if (this.container.getState().equals((Object)ContainerState.VALIDATED)) {
            this.validator.validateInjectionTarget(injectionTarget, this.beanManager);
        } else {
            this.injectionTargets.add(injectionTarget);
        }
    }

    public void validate() {
        for (InjectionTarget<?> injectionTarget : this.injectionTargets) {
            this.validator.validateInjectionTarget(injectionTarget, this.beanManager);
        }
        this.injectionTargets.clear();
    }

    @Override
    public void cleanup() {
    }
}

