/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotated;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.serialization.AbstractSerializableHolder;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.reflection.RawType;
import org.jboss.weld.util.reflection.Reflections;

public abstract class BackedAnnotatedMember<X>
extends BackedAnnotated
implements AnnotatedMember<X> {
    private BackedAnnotatedType<X> declaringType;

    public BackedAnnotatedMember(Type baseType, BackedAnnotatedType<X> declaringType, SharedObjectCache sharedObjectCache) {
        super(baseType, sharedObjectCache);
        this.declaringType = declaringType;
    }

    @Override
    protected LazyValueHolder<Set<Type>> initTypeClosure(Type baseType, SharedObjectCache cache) {
        return cache.getTypeClosureHolder(RawType.wrap(baseType));
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic(this.getJavaMember());
    }

    @Override
    public BackedAnnotatedType<X> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    protected ReflectionCache getReflectionCache() {
        return ((BackedAnnotatedType)this.getDeclaringType()).getReflectionCache();
    }

    protected static abstract class BackedAnnotatedMemberSerializationProxy<X, A extends AnnotatedMember<? super X>>
    implements Serializable {
        private static final long serialVersionUID = 450947485748828056L;
        protected final BackedAnnotatedType<X> type;
        private final AbstractSerializableHolder<? extends Member> memberHolder;

        public BackedAnnotatedMemberSerializationProxy(BackedAnnotatedType<X> type, AbstractSerializableHolder<? extends Member> memberHolder) {
            this.type = type;
            this.memberHolder = memberHolder;
        }

        protected A resolve() {
            for (AnnotatedMember annotatedMember : this.getCandidates()) {
                if (!annotatedMember.getJavaMember().equals(this.memberHolder.get())) continue;
                return (A)annotatedMember;
            }
            throw new IllegalStateException(BeanMessage.UNABLE_TO_LOAD_MEMBER, this.memberHolder.get());
        }

        protected abstract Iterable<A> getCandidates();
    }
}

