/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.ForwardingWeldParameter;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class ParameterInjectionPoint<T, X>
extends ForwardingWeldParameter<T, X>
implements WeldInjectionPoint<T, Object>,
Serializable {
    @SuppressWarnings(value={"SE_BAD_FIELD"}, justification="If the bean is not serializable, we won't ever try to serialize the injection point")
    private final Bean<?> declaringBean;
    private final WeldParameter<T, X> parameter;
    private final boolean delegate;
    private final boolean cacheable;
    private Bean<?> cachedBean;

    public static <T, X> ParameterInjectionPoint<T, X> of(Bean<?> declaringBean, WeldParameter<T, X> parameter) {
        return new ParameterInjectionPoint<T, X>(declaringBean, parameter);
    }

    private ParameterInjectionPoint(Bean<?> declaringBean, WeldParameter<T, X> parameter) {
        this.declaringBean = declaringBean;
        this.parameter = parameter;
        this.delegate = this.isAnnotationPresent(Delegate.class) && declaringBean instanceof Decorator;
        this.cacheable = !this.delegate && !InjectionPoint.class.isAssignableFrom(parameter.getJavaClass()) && !Instance.class.isAssignableFrom(parameter.getJavaClass());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ParameterInjectionPoint) {
            ParameterInjectionPoint ip = (ParameterInjectionPoint)obj;
            if (this.parameter.getDeclaringWeldCallable().getJavaMember().equals(ip.parameter.getDeclaringWeldCallable().getJavaMember()) && ((Object)this.parameter.getAnnotations()).equals(ip.parameter.getAnnotations()) && this.parameter.getPosition() == ip.parameter.getPosition()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.parameter.hashCode();
    }

    @Override
    protected WeldParameter<T, X> delegate() {
        return this.parameter;
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegate().getQualifiers();
    }

    public Member getJavaMember() {
        return this.delegate().getDeclaringCallable().getJavaMember();
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        throw new UnsupportedOperationException();
    }

    public T getValueToInject(BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        Object objectToInject;
        if (!this.cacheable) {
            objectToInject = Reflections.cast(manager.getInjectableReference(this, creationalContext));
        } else {
            if (this.cachedBean == null) {
                this.cachedBean = manager.resolve(manager.getBeans(this));
            }
            objectToInject = Reflections.cast(manager.getReference(this, this.cachedBean, creationalContext));
        }
        return objectToInject;
    }

    @Override
    public Annotated getAnnotated() {
        return this.delegate();
    }

    @Override
    public boolean isDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public Type getType() {
        return this.getBaseType();
    }

    @Override
    public Member getMember() {
        return this.getJavaMember();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy<T>
    extends WeldInjectionPoint.WeldInjectionPointSerializationProxy<T, Object> {
        private static final long serialVersionUID = -3491482804822264969L;
        private final int parameterPosition;
        private final MethodSignature methodSignature;
        private final ConstructorSignature constructorSignature;

        public SerializationProxy(ParameterInjectionPoint<T, ?> injectionPoint) {
            super(injectionPoint);
            this.parameterPosition = injectionPoint.getPosition();
            if (injectionPoint.delegate().getDeclaringWeldCallable() instanceof WeldMethod) {
                this.methodSignature = ((WeldMethod)injectionPoint.delegate().getDeclaringWeldCallable()).getSignature();
                this.constructorSignature = null;
            } else if (injectionPoint.delegate().getDeclaringWeldCallable() instanceof WeldConstructor) {
                this.methodSignature = null;
                this.constructorSignature = ((WeldConstructor)injectionPoint.delegate().getDeclaringWeldCallable()).getSignature();
            } else {
                throw new IllegalStateException(BeanMessage.IP_NOT_CONSTRUCTOR_OR_METHOD, injectionPoint);
            }
        }

        private Object readResolve() {
            WeldParameter<T, ?> parameter = this.getWeldParameter();
            Bean bean = this.getDeclaringBean();
            if (parameter == null || bean == null && this.getDeclaringBeanId() != null) {
                throw new IllegalStateException(ReflectionMessage.UNABLE_TO_GET_PARAMETER_ON_DESERIALIZATION, this.getDeclaringBeanId(), this.getDeclaringWeldClass(), this.methodSignature, this.parameterPosition);
            }
            return ParameterInjectionPoint.of(this.getDeclaringBean(), this.getWeldParameter());
        }

        protected WeldParameter<T, ?> getWeldParameter() {
            if (this.methodSignature != null) {
                WeldMethod method = this.getDeclaringWeldClass().getDeclaredWeldMethod(this.methodSignature);
                if (method.getParameters().size() > this.parameterPosition) {
                    return (WeldParameter)Reflections.cast(method.getWeldParameters().get(this.parameterPosition));
                }
                throw new IllegalStateException(BeanMessage.PARAM_NOT_IN_PARAM_LIST, this.parameterPosition, method.getParameters());
            }
            if (this.constructorSignature != null) {
                WeldConstructor<?> constructor = this.getDeclaringWeldClass().getDeclaredWeldConstructor(this.constructorSignature);
                if (constructor.getParameters().size() > this.parameterPosition) {
                    return (WeldParameter)Reflections.cast(constructor.getWeldParameters().get(this.parameterPosition));
                }
                throw new IllegalStateException(BeanMessage.PARAM_NOT_IN_PARAM_LIST, this.parameterPosition, constructor.getParameters());
            }
            throw new IllegalStateException(BeanMessage.CANNOT_READ_OBJECT, new Object[0]);
        }
    }
}

