/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.DisposerInfo;
import jakarta.enterprise.inject.build.compatible.spi.InjectionPointInfo;
import jakarta.enterprise.inject.build.compatible.spi.ScopeInfo;
import jakarta.enterprise.inject.build.compatible.spi.StereotypeInfo;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.BeanManagerAccess;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.DisposerInfoImpl;
import org.jboss.weld.lite.extension.translator.FieldInfoImpl;
import org.jboss.weld.lite.extension.translator.InjectionPointInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.ScopeInfoImpl;
import org.jboss.weld.lite.extension.translator.StereotypeInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class BeanInfoImpl
implements BeanInfo {
    final Bean<?> cdiBean;
    final Annotated cdiDeclaration;
    final AnnotatedParameter<?> cdiDisposerDeclaration;

    BeanInfoImpl(Bean<?> cdiBean, Annotated cdiDeclaration, AnnotatedParameter<?> cdiDisposerDeclaration) {
        this.cdiBean = cdiBean;
        this.cdiDeclaration = cdiDeclaration;
        this.cdiDisposerDeclaration = cdiDisposerDeclaration;
    }

    public ScopeInfo scope() {
        AnnotatedType scopeType = BeanManagerAccess.createAnnotatedType(this.cdiBean.getScope());
        boolean isNormal = scopeType.isAnnotationPresent(NormalScope.class);
        return new ScopeInfoImpl(new ClassInfoImpl(scopeType), isNormal);
    }

    public Collection<Type> types() {
        return this.cdiBean.getTypes().stream().map(it -> TypeImpl.fromReflectionType(AnnotatedTypes.from(it))).collect(Collectors.toList());
    }

    public Collection<AnnotationInfo> qualifiers() {
        return this.cdiBean.getQualifiers().stream().map(AnnotationInfoImpl::new).collect(Collectors.toList());
    }

    public ClassInfo declaringClass() {
        AnnotatedType beanClass = BeanManagerAccess.createAnnotatedType(this.cdiBean.getBeanClass());
        return new ClassInfoImpl(beanClass);
    }

    public boolean isClassBean() {
        return this.cdiDeclaration instanceof AnnotatedType;
    }

    public boolean isProducerMethod() {
        return this.cdiDeclaration instanceof AnnotatedMethod;
    }

    public boolean isProducerField() {
        return this.cdiDeclaration instanceof AnnotatedField;
    }

    public boolean isSynthetic() {
        return this.cdiDeclaration == null;
    }

    public MethodInfo producerMethod() {
        if (this.cdiDeclaration instanceof AnnotatedMethod) {
            return new MethodInfoImpl((AnnotatedCallable<?>)((AnnotatedMethod)this.cdiDeclaration));
        }
        return null;
    }

    public FieldInfo producerField() {
        if (this.cdiDeclaration instanceof AnnotatedField) {
            return new FieldInfoImpl((AnnotatedField)this.cdiDeclaration);
        }
        return null;
    }

    public boolean isAlternative() {
        return this.cdiBean.isAlternative();
    }

    public Integer priority() {
        if (this.cdiDeclaration instanceof AnnotatedType && this.cdiDeclaration.isAnnotationPresent(Priority.class)) {
            return ((Priority)this.cdiDeclaration.getAnnotation(Priority.class)).value();
        }
        if (this.cdiBean instanceof Prioritized) {
            return ((Prioritized)this.cdiBean).getPriority();
        }
        return null;
    }

    public String name() {
        return this.cdiBean.getName();
    }

    public DisposerInfo disposer() {
        if (this.cdiDisposerDeclaration != null) {
            return new DisposerInfoImpl(this.cdiDisposerDeclaration);
        }
        return null;
    }

    public Collection<StereotypeInfo> stereotypes() {
        return this.cdiBean.getStereotypes().stream().map(StereotypeInfoImpl::new).collect(Collectors.toList());
    }

    public Collection<InjectionPointInfo> injectionPoints() {
        return this.cdiBean.getInjectionPoints().stream().map(InjectionPointInfoImpl::new).collect(Collectors.toList());
    }

    public String toString() {
        return "@" + this.cdiBean.getScope().getSimpleName() + " bean [types=" + this.cdiBean.getTypes() + ", qualifiers=" + this.cdiBean.getQualifiers() + "]" + (String)(this.cdiDeclaration != null ? " declared at " + this.cdiDeclaration : "");
    }
}

