/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Set;
import org.jboss.weld.resolution.AssignabilityRules;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.Reflections;

public class EventTypeAssignabilityRules
implements AssignabilityRules {
    private static final EventTypeAssignabilityRules INSTANCE = new EventTypeAssignabilityRules();
    public static final Type[] EMPTY_TYPES = new Type[0];

    protected EventTypeAssignabilityRules() {
    }

    public static EventTypeAssignabilityRules instance() {
        return INSTANCE;
    }

    public boolean isAssignableTo(Type type1, Type[] types2) {
        return this.isAssignableFrom(types2, type1);
    }

    @Override
    public boolean isAssignableFrom(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!this.isAssignableFrom(type1, type)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (!this.isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(Type[] types1, Type type2) {
        for (Type type : types1) {
            if (!this.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(Type type1, Type type2) {
        Type requiredType = this.wrapWithinTypeHolder(type1);
        if (requiredType instanceof ActualTypeHolder) {
            return this.isAssignableFrom((ActualTypeHolder)requiredType, type2);
        }
        if (requiredType instanceof WildcardType) {
            return this.isAssignableFrom((WildcardType)requiredType, type2);
        }
        if (requiredType instanceof TypeVariable) {
            return this.isAssignableFrom((TypeVariable)requiredType, type2);
        }
        return false;
    }

    protected boolean isAssignableFrom(ActualTypeHolder requiredType, Type otherType) {
        TypeVariable typeVariable;
        if ((otherType = this.wrapWithinTypeHolder(otherType)) instanceof ActualTypeHolder) {
            return this.isAssignableFrom(requiredType, (ActualTypeHolder)otherType);
        }
        if (otherType instanceof TypeVariable && this.isTypeInsideBounds(requiredType, EMPTY_TYPES, (typeVariable = (TypeVariable)otherType).getBounds())) {
            return true;
        }
        if (otherType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)otherType;
            for (Type upperBound : wildcardType.getUpperBounds()) {
                if (!this.isAssignableFrom(requiredType, upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAssignableFrom(ActualTypeHolder requiredType, ActualTypeHolder otherTypeHolder) {
        return requiredType.getBoxedRawType().isAssignableFrom(otherTypeHolder.getBoxedRawType()) && this.areActualTypeArgumentsAssignableFrom(requiredType, otherTypeHolder.getActualTypeArguments());
    }

    protected boolean isAssignableFrom(WildcardType requiredType, Type beanType) {
        return this.isTypeInsideBounds(beanType, requiredType.getLowerBounds(), requiredType.getUpperBounds());
    }

    protected boolean isAssignableFrom(TypeVariable<?> requiredType, Type beanType) {
        return this.isTypeInsideBounds(beanType, EMPTY_TYPES, requiredType.getBounds());
    }

    protected boolean areActualTypeArgumentsAssignableFrom(ActualTypeHolder requiredType, Type[] otherActualTypeArguments) {
        for (int i = 0; i < requiredType.getActualTypeArguments().length; ++i) {
            Class<Object> type2;
            Type type1 = requiredType.getActualTypeArguments()[i];
            Class<Object> clazz = type2 = otherActualTypeArguments.length > i ? otherActualTypeArguments[i] : Object.class;
            if (this.isAssignableFrom(type1, (Type)((Object)type2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(Set<Type> requiredTypes, Set<Type> beanTypes) {
        for (Type requiredType : requiredTypes) {
            if (!this.matches(requiredType, beanTypes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Type requiredType, Set<? extends Type> beanTypes) {
        for (Type type : beanTypes) {
            if (!this.matches(requiredType, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Type requiredType, Type beanType) {
        if ((requiredType = this.wrapWithinTypeHolder(requiredType)) instanceof ActualTypeHolder) {
            return this.matches((ActualTypeHolder)requiredType, beanType);
        }
        if (requiredType instanceof WildcardType) {
            return this.matches((WildcardType)requiredType, beanType);
        }
        if (requiredType instanceof TypeVariable) {
            return this.matches((TypeVariable)requiredType, beanType);
        }
        return false;
    }

    protected boolean matches(WildcardType requiredType, Type beanType) {
        return this.isAssignableFrom(requiredType, beanType);
    }

    protected boolean matches(TypeVariable<?> requiredType, Type beanType) {
        return this.isAssignableFrom(requiredType, beanType);
    }

    public boolean isTypeInsideBounds(Type type, Type[] lowerBounds, Type[] upperBounds) {
        return !(lowerBounds.length != 0 && !this.isAssignableFrom(type, lowerBounds) || upperBounds.length != 0 && !this.isAssignableTo(type, upperBounds));
    }

    public boolean areTypesInsideBounds(Type[] types, Type[] lowerBounds, Type[] upperBounds) {
        for (Type type : types) {
            if (this.isTypeInsideBounds(type, lowerBounds, upperBounds)) continue;
            return false;
        }
        return true;
    }

    protected boolean matches(ActualTypeHolder requiredType, Type otherType) {
        TypeVariable typeVariable;
        if ((otherType = this.wrapWithinTypeHolder(otherType)) instanceof ActualTypeHolder) {
            return this.matches(requiredType, (ActualTypeHolder)otherType);
        }
        if (otherType instanceof TypeVariable && this.isTypeInsideBounds(requiredType, EMPTY_TYPES, (typeVariable = (TypeVariable)otherType).getBounds())) {
            return true;
        }
        if (otherType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)otherType;
            for (Type upperBound : wildcardType.getUpperBounds()) {
                if (!this.matches(requiredType, upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean matches(ActualTypeHolder requiredType, ActualTypeHolder otherTypeHolder) {
        return requiredType.getBoxedRawType().equals(otherTypeHolder.getBoxedRawType()) && this.areActualTypeArgumentsMatching(requiredType, otherTypeHolder.getActualTypeArguments());
    }

    protected boolean areActualTypeArgumentsMatching(ActualTypeHolder requiredType, Type[] otherActualTypeArguments) {
        for (int i = 0; i < requiredType.getActualTypeArguments().length; ++i) {
            Class<Object> type2;
            Type type1 = requiredType.getActualTypeArguments()[i];
            Class<Object> clazz = type2 = otherActualTypeArguments.length > i ? otherActualTypeArguments[i] : Object.class;
            if (this.matches(type1, (Type)((Object)type2))) continue;
            return false;
        }
        return true;
    }

    protected Type wrapWithinTypeHolder(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                Class clazz = (Class)rawType;
                return new ActualTypeHolder(clazz, parameterizedType.getActualTypeArguments());
            }
        } else {
            GenericArrayType arrayType;
            Type genericComponentType;
            Class rawComponentType;
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return new ActualTypeHolder(clazz, EMPTY_TYPES);
            }
            if (type instanceof GenericArrayType && (rawComponentType = Reflections.getRawType(genericComponentType = (arrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
                Class<?> arrayClass = Array.newInstance(rawComponentType, 0).getClass();
                return new ActualTypeHolder(arrayClass, Reflections.getActualTypeArguments(genericComponentType));
            }
        }
        return type;
    }

    protected static class ActualTypeHolder
    implements Type {
        private Class<?> rawType;
        private Type[] actualTypeArguments;

        private ActualTypeHolder(Class<?> rawType, Type[] actualTypeArguments) {
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
        }

        public Class<?> getRawType() {
            return this.rawType;
        }

        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        private Class<?> getBoxedRawType() {
            return Types.boxedClass(this.getRawType());
        }

        public String toString() {
            return "ActualTypeHolder [rawType=" + this.rawType + ", actualTypeArguments=" + Arrays.toString(this.actualTypeArguments) + "]";
        }
    }
}

