/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.net.URL;
import java.util.HashMap;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.client.util.SpringUtils;
import org.jboss.wsf.stack.cxf.metadata.MetadataBuilder;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;

public class DescriptorDeploymentAspect
extends AbstractDeploymentAspect {
    private static final boolean PREFER_SPRING_DESCRIPTOR_GENERATION = Boolean.getBoolean("org.jboss.ws.cxf.prefer_spring_descriptor_generation");

    public void start(Deployment dep) {
        URL cxfURL = null;
        if (SpringUtils.isSpringAvailable((ClassLoader[])new ClassLoader[0]) && (cxfURL = this.getCXFConfigFromDeployment(dep)) != null) {
            this.putCXFConfigToDeployment(dep, "jbossws.cxf.beans.url", cxfURL);
        }
        DDBeans dd = this.generateMetadataFromDeployment(dep);
        if (cxfURL != null || PREFER_SPRING_DESCRIPTOR_GENERATION) {
            URL generated = dd.createFileURL();
            Loggers.DEPLOYMENT_LOGGER.jbwscxfConfGenerated(generated);
            this.putCXFConfigToDeployment(dep, "jbossws.cxf.gen.url", generated);
        }
    }

    public void stop(Deployment dep) {
        DDBeans dd = (DDBeans)dep.getAttachment(DDBeans.class);
        if (dd != null) {
            dd.destroyFileURL();
        }
    }

    private URL getCXFConfigFromDeployment(Deployment dep) {
        String metadir = null;
        metadir = WSHelper.isJseDeployment((Deployment)dep) || WSHelper.isWarArchive((Deployment)dep) ? "WEB-INF" : "META-INF";
        URL cxfURL = null;
        ArchiveDeployment archDep = (ArchiveDeployment)dep;
        cxfURL = archDep.getResourceResolver().resolveFailSafe(metadir + "/" + "jbossws-cxf.xml");
        if (cxfURL != null) {
            Loggers.DEPLOYMENT_LOGGER.jbwscxfConfFound(cxfURL);
        }
        return cxfURL;
    }

    private DDBeans generateMetadataFromDeployment(Deployment dep) {
        MetadataBuilder builder = new MetadataBuilder();
        DDBeans dd = builder.build(dep);
        dep.addAttachment(DDBeans.class, (Object)dd);
        return dd;
    }

    private void putCXFConfigToDeployment(Deployment dep, String key, URL value) {
        HashMap<String, String> contextParams = (HashMap<String, String>)dep.getProperty("stack.context.parameters");
        if (contextParams == null) {
            contextParams = new HashMap<String, String>();
            dep.setProperty("stack.context.parameters", contextParams);
        }
        contextParams.put(key, value.toExternalForm());
    }
}

