/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceContext;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.injection.InjectionException;
import org.jboss.wsf.common.injection.finders.EJBFieldFinder;
import org.jboss.wsf.common.injection.finders.EJBMethodFinder;
import org.jboss.wsf.common.injection.finders.InjectionFieldFinder;
import org.jboss.wsf.common.injection.finders.InjectionMethodFinder;
import org.jboss.wsf.common.injection.finders.PostConstructMethodFinder;
import org.jboss.wsf.common.injection.finders.PreDestroyMethodFinder;
import org.jboss.wsf.common.injection.finders.ResourceFieldFinder;
import org.jboss.wsf.common.injection.finders.ResourceMethodFinder;
import org.jboss.wsf.common.reflection.ClassProcessor;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionHelper {
    private static final Logger LOG = Logger.getLogger(InjectionHelper.class);
    private static final String POJO_JNDI_PREFIX = "java:comp/env/";
    private static final ClassProcessor<Method> POST_CONSTRUCT_METHOD_FINDER = new PostConstructMethodFinder();
    private static final ClassProcessor<Method> PRE_DESTROY_METHOD_FINDER = new PreDestroyMethodFinder();
    private static final ClassProcessor<Method> RESOURCE_METHOD_FINDER = new ResourceMethodFinder(WebServiceContext.class, false);
    private static final ClassProcessor<Field> RESOURCE_FIELD_FINDER = new ResourceFieldFinder(WebServiceContext.class, false);
    private static final ClassProcessor<Method> EJB_METHOD_FINDER = new EJBMethodFinder();
    private static final ClassProcessor<Field> EJB_FIELD_FINDER = new EJBFieldFinder();
    private static final ClassProcessor<Method> WEB_SERVICE_CONTEXT_METHOD_FINDER = new ResourceMethodFinder(WebServiceContext.class, true);
    private static final ClassProcessor<Field> WEB_SERVICE_CONTEXT_FIELD_FINDER = new ResourceFieldFinder(WebServiceContext.class, true);

    private InjectionHelper() {
    }

    public static void injectResources(Object instance, InjectionsMetaData injections) {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        if (injections == null) {
            return;
        }
        Context ctx = InjectionHelper.getContext(injections);
        Collection injectionMDs = injections.getInjectionsMetaData(instance.getClass());
        for (InjectionMetaData injectionMD : injectionMDs) {
            InjectionHelper.injectDescriptorAnnotatedAccessibleObjects(instance, ctx, injectionMD);
        }
        InjectionHelper.injectResourceAnnotatedAccessibleObjects(instance, ctx, injections);
        InjectionHelper.injectEJBAnnotatedAccessibleObjects(instance, InjectionHelper.getDefaultContext(), injections);
    }

    public static void injectWebServiceContext(Object instance, WebServiceContext ctx) {
        Class<?> instanceClass = instance.getClass();
        Collection<Method> resourceAnnotatedMethods = WEB_SERVICE_CONTEXT_METHOD_FINDER.process(instanceClass);
        for (Method method : resourceAnnotatedMethods) {
            try {
                InjectionHelper.invokeMethod(instance, method, new Object[]{ctx});
            }
            catch (Exception e) {
                String message = "Cannot inject @Resource annotated method: " + method;
                InjectionException.rethrow(message, e);
            }
        }
        Collection<Field> resourceAnnotatedFields = WEB_SERVICE_CONTEXT_FIELD_FINDER.process(instanceClass);
        for (Field field : resourceAnnotatedFields) {
            try {
                InjectionHelper.setField(instance, field, ctx);
            }
            catch (Exception e) {
                String message = "Cannot inject @Resource annotated field: " + field;
                InjectionException.rethrow(message, e);
            }
        }
    }

    public static void callPostConstructMethod(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        Collection<Method> methods = POST_CONSTRUCT_METHOD_FINDER.process(instance.getClass());
        if (methods.size() > 0) {
            Method method = methods.iterator().next();
            LOG.debug((Object)("Calling @PostConstruct annotated method: " + method));
            try {
                InjectionHelper.invokeMethod(instance, method, null);
            }
            catch (Exception e) {
                String message = "Calling of @PostConstruct annotated method failed: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    public static void callPreDestroyMethod(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        Collection<Method> methods = PRE_DESTROY_METHOD_FINDER.process(instance.getClass());
        if (methods.size() > 0) {
            Method method = methods.iterator().next();
            LOG.debug((Object)("Calling @PreDestroy annotated method: " + method));
            try {
                InjectionHelper.invokeMethod(instance, method, null);
            }
            catch (Exception e) {
                String message = "Calling of @PreDestroy annotated method failed: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    private static Context getContext(InjectionsMetaData injections) {
        Context ctx = injections.getContext();
        if (ctx == null) {
            try {
                return (Context)InjectionHelper.getDefaultContext().lookup(POJO_JNDI_PREFIX);
            }
            catch (NamingException ne) {
                InjectionException.rethrow("Cannot lookup JNDI context: java:comp/env/", ne);
            }
        }
        return ctx;
    }

    private static void injectDescriptorAnnotatedAccessibleObjects(Object instance, Context ctx, InjectionMetaData injectionMD) {
        Method method = InjectionHelper.getMethod(injectionMD, instance.getClass());
        if (method != null) {
            try {
                InjectionHelper.inject(instance, method, injectionMD.getEnvEntryName(), ctx);
            }
            catch (Exception e) {
                String message = "Cannot inject method (descriptor driven injection): " + injectionMD;
                InjectionException.rethrow(message, e);
            }
        } else {
            Field field = InjectionHelper.getField(injectionMD, instance.getClass());
            if (field != null) {
                try {
                    InjectionHelper.inject(instance, field, injectionMD.getEnvEntryName(), ctx);
                }
                catch (Exception e) {
                    String message = "Cannot inject field (descriptor driven injection): " + injectionMD;
                    InjectionException.rethrow(message, e);
                }
            } else {
                String message = "Cannot find injection target for: " + injectionMD;
                throw new InjectionException(message);
            }
        }
    }

    private static void injectResourceAnnotatedAccessibleObjects(Object instance, Context ctx, InjectionsMetaData injections) {
        Collection<Field> resourceAnnotatedFields = RESOURCE_FIELD_FINDER.process(instance.getClass());
        for (Field field : resourceAnnotatedFields) {
            try {
                String jndiName = injections.getResolver(Resource.class).resolve((AccessibleObject)field);
                InjectionHelper.inject(instance, field, jndiName, ctx);
            }
            catch (Exception e) {
                String message = "Cannot inject field annotated with @Resource annotation: " + field;
                InjectionException.rethrow(message, e);
            }
        }
        Collection<Method> resourceAnnotatedMethods = RESOURCE_METHOD_FINDER.process(instance.getClass());
        for (Method method : resourceAnnotatedMethods) {
            try {
                String jndiName = injections.getResolver(Resource.class).resolve((AccessibleObject)method);
                InjectionHelper.inject(instance, method, jndiName, ctx);
            }
            catch (Exception e) {
                String message = "Cannot inject method annotated with @Resource annotation: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    private static void injectEJBAnnotatedAccessibleObjects(Object instance, Context ctx, InjectionsMetaData injections) {
        Collection<Field> ejbAnnotatedFields = EJB_FIELD_FINDER.process(instance.getClass());
        for (Field field : ejbAnnotatedFields) {
            try {
                String jndiName = injections.getResolver(EJB.class).resolve((AccessibleObject)field);
                InjectionHelper.inject(instance, field, jndiName, ctx);
            }
            catch (Exception e) {
                String message = "Cannot inject field annotated with @EJB annotation: " + field;
                InjectionException.rethrow(message, e);
            }
        }
        Collection<Method> ejbAnnotatedMethods = EJB_METHOD_FINDER.process(instance.getClass());
        for (Method method : ejbAnnotatedMethods) {
            try {
                String jndiName = injections.getResolver(EJB.class).resolve((AccessibleObject)method);
                InjectionHelper.inject(instance, method, jndiName, ctx);
            }
            catch (Exception e) {
                String message = "Cannot inject method annotated with @EJB annotation: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    private static void inject(Object instance, Method method, String jndiName, Context ctx) {
        Object value = InjectionHelper.lookup(jndiName, ctx);
        LOG.debug((Object)("Injecting method: " + method));
        InjectionHelper.invokeMethod(instance, method, new Object[]{value});
    }

    private static void inject(Object instance, Field field, String jndiName, Context ctx) {
        Object value = InjectionHelper.lookup(jndiName, ctx);
        LOG.debug((Object)("Injecting field: " + field));
        InjectionHelper.setField(instance, field, value);
    }

    private static Object lookup(String jndiName, Context ctx) {
        Object value = null;
        try {
            value = ctx.lookup(jndiName);
        }
        catch (NamingException ne) {
            String message = "Resource '" + jndiName + "' not found";
            InjectionException.rethrow(message, ne);
        }
        return value;
    }

    private static Context getDefaultContext() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ne) {
            String message = "Cannot create default JNDI context";
            InjectionException.rethrow("Cannot create default JNDI context", ne);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeMethod(Object instance, Method method, Object[] args) {
        boolean accessability = method.isAccessible();
        try {
            method.setAccessible(true);
            method.invoke(instance, args);
        }
        catch (Exception e) {
            InjectionException.rethrow(e);
        }
        finally {
            method.setAccessible(accessability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setField(Object instance, Field field, Object value) {
        boolean accessability = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            InjectionException.rethrow(e);
        }
        finally {
            field.setAccessible(accessability);
        }
    }

    private static Method getMethod(InjectionMetaData injectionMD, Class<?> clazz) {
        Collection result = new InjectionMethodFinder(injectionMD).process(clazz);
        return result.isEmpty() ? null : (Method)result.iterator().next();
    }

    private static Field getField(InjectionMetaData injectionMD, Class<?> clazz) {
        Collection result = new InjectionFieldFinder(injectionMD).process(clazz);
        return result.isEmpty() ? null : (Field)result.iterator().next();
    }
}

