/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.ResourceBundle;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public final class VirtualHostDeploymentAspect
extends AbstractDeploymentAspect {
    private static final ResourceBundle bundle = BundleUtils.getBundle(VirtualHostDeploymentAspect.class);

    @Override
    public void start(Deployment dep) {
        if (WSHelper.isJaxwsEjbDeployment(dep)) {
            dep.getService().setVirtualHost(this.getExplicitVirtualHost(dep));
        }
    }

    protected String getExplicitVirtualHost(Deployment dep) {
        String virtualHost = null;
        for (Endpoint ep : dep.getService().getEndpoints()) {
            Class implClass = ep.getTargetBeanClass();
            WebContext webContext = implClass.getAnnotation(WebContext.class);
            if (!VirtualHostDeploymentAspect.hasVirtualHost(webContext)) continue;
            String currentVirtualHost = webContext.virtualHost().trim();
            if (virtualHost == null) {
                virtualHost = currentVirtualHost;
                continue;
            }
            if (currentVirtualHost.equals(virtualHost)) continue;
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"VIRTUALHOST_MUST_BE_THE_SAME_FOR_ALL_DEPLOYED_ENDPOINTS", (Object[])new Object[0]));
        }
        return virtualHost;
    }

    private static boolean hasVirtualHost(WebContext webContext) {
        return webContext != null && webContext.virtualHost().trim().length() > 0;
    }
}

