/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointResolver;

public class DefaultEndpointRegistry
implements EndpointRegistry {
    private final Map<ObjectName, Endpoint> endpoints = new ConcurrentHashMap<ObjectName, Endpoint>();

    public Endpoint getEndpoint(ObjectName epName) {
        if (epName == null) {
            throw Messages.MESSAGES.endpointNameCannotBeNull();
        }
        if (!this.isRegistered(epName)) {
            throw Messages.MESSAGES.endpointNotRegistered(epName);
        }
        Endpoint endpoint = this.endpoints.get(epName);
        return endpoint;
    }

    public Endpoint resolve(EndpointResolver resolver) {
        return resolver.query(this.endpoints.values().iterator());
    }

    public boolean isRegistered(ObjectName epName) {
        if (epName == null) {
            throw Messages.MESSAGES.endpointNameCannotBeNull();
        }
        return this.endpoints.get(epName) != null;
    }

    public Set<ObjectName> getEndpoints() {
        return this.endpoints.keySet();
    }

    public void register(Endpoint endpoint) {
        if (endpoint == null) {
            throw Messages.MESSAGES.cannotRegisterUnregisterNullEndpoint();
        }
        ObjectName epName = endpoint.getName();
        if (epName == null) {
            throw Messages.MESSAGES.cannotRegisterEndpointWithNullName(endpoint.getName());
        }
        if (this.isRegistered(epName)) {
            throw Messages.MESSAGES.endpointAlreadyRegistered(epName);
        }
        Loggers.MANAGEMENT_LOGGER.endpointRegistered(epName);
        this.endpoints.put(epName, endpoint);
    }

    public void unregister(Endpoint endpoint) {
        if (endpoint == null) {
            throw Messages.MESSAGES.cannotRegisterUnregisterNullEndpoint();
        }
        ObjectName epName = endpoint.getName();
        if (!this.isRegistered(epName)) {
            throw Messages.MESSAGES.endpointNotRegistered(epName);
        }
        Loggers.MANAGEMENT_LOGGER.endpointUnregistered(epName);
        this.endpoints.remove(epName);
    }
}

