/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jbpm.kie.services.api.DeployedUnit;
import org.jbpm.kie.services.api.DeploymentService;
import org.jbpm.kie.services.api.Vfs;
import org.jbpm.kie.services.impl.VFSDeploymentUnit;
import org.jbpm.runtime.manager.api.WorkItemHandlerProducer;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.commons.java.nio.file.Path;
import org.mvel2.MVEL;

public class VfsMVELWorkItemHandlerProducer
implements WorkItemHandlerProducer {
    @Inject
    private FileService fs;
    @Inject
    @Vfs
    private Instance<DeploymentService> deploymentService;

    public void setFs(FileService fs) {
        this.fs = fs;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(String identifier, Map<String, Object> params) {
        HashMap<String, WorkItemHandler> handlers = new HashMap<String, WorkItemHandler>();
        try {
            if (this.deploymentService.get() == null) {
                return handlers;
            }
            DeployedUnit deployedUnit = ((DeploymentService)this.deploymentService.get()).getDeployedUnit(identifier);
            if (deployedUnit == null) {
                return handlers;
            }
            VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)deployedUnit.getDeploymentUnit();
            Path assetFolder = this.fs.getPath(vfsUnit.getRepository() + vfsUnit.getRepositoryFolder());
            if (identifier == null || !this.fs.exists(assetFolder)) {
                return handlers;
            }
            params.put("fs", this.fs);
            Iterable widFiles = this.fs.loadFilesByType(assetFolder, "conf");
            for (Path widPath : widFiles) {
                String content = new String(this.fs.loadFile(widPath), "UTF-8");
                handlers.putAll((Map)MVEL.eval((String)content, params));
            }
        }
        catch (FileException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handlers;
    }
}

