/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.form.model.Mappable;
import org.jbpm.kie.services.impl.form.model.ScriptData;
import org.jbpm.kie.services.impl.form.model.forms.FormEncodingException;

public class ScriptRepresentation
implements Mappable {
    private String documentation;
    private String id;
    private List<ScriptData> helpers;
    private String type;
    private String src;
    private String content;
    private String invokeFunction;

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getContent() {
        if (this.helpers != null && !this.helpers.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ScriptData helper : this.helpers) {
                String asScriptContent = helper.get("script");
                asScriptContent = asScriptContent.replaceAll("\"", "\\\"").replaceAll("\n", "");
                sb.append(asScriptContent);
            }
            return sb.toString();
        }
        return this.content;
    }

    public void setHelpers(List<ScriptData> helpers) {
        this.helpers = helpers;
    }

    public List<ScriptData> getHelpers() {
        return this.helpers;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getInvokeFunction() {
        return this.invokeFunction;
    }

    public void setInvokeFunction(String invokeFunction) {
        this.invokeFunction = invokeFunction;
    }

    @Override
    public Map<String, Object> getDataMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("@className", this.getClass().getName());
        data.put("documentation", this.documentation);
        data.put("id", this.id);
        data.put("type", this.type);
        data.put("src", this.src);
        data.put("content", this.content);
        if (this.getHelpers() != null) {
            ArrayList<Map<String, Object>> helpersMap = new ArrayList<Map<String, Object>>();
            for (ScriptData helper : this.getHelpers()) {
                helpersMap.add(helper.getDataMap());
            }
            data.put("helpers", helpersMap);
        }
        data.put("invokeFunction", this.invokeFunction);
        return data;
    }

    @Override
    public void setDataMap(Map<String, Object> dataMap) throws FormEncodingException {
        this.documentation = (String)dataMap.get("documentation");
        this.id = (String)dataMap.get("id");
        this.type = (String)dataMap.get("type");
        this.src = (String)dataMap.get("src");
        this.content = (String)dataMap.get("content");
        this.invokeFunction = (String)dataMap.get("invokeFunction");
        List helpersMap = (List)dataMap.get("helpers");
        if (helpersMap != null) {
            ArrayList<ScriptData> myHelpers = new ArrayList<ScriptData>();
            for (Object obj : helpersMap) {
                try {
                    Map helperMap = (Map)obj;
                    String helperClass = (String)helperMap.get("@className");
                    Class<?> clazz = Class.forName(helperClass);
                    ScriptData helper = (ScriptData)clazz.newInstance();
                    helper.setDataMap(helperMap);
                }
                catch (Exception e) {
                    throw new FormEncodingException("Problem creating helper " + obj, e);
                }
            }
            this.setHelpers(myHelpers);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.documentation == null ? 0 : this.documentation.hashCode());
        result = 31 * result + (this.helpers == null ? 0 : ((Object)this.helpers).hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.invokeFunction == null ? 0 : this.invokeFunction.hashCode());
        result = 31 * result + (this.src == null ? 0 : this.src.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptRepresentation other = (ScriptRepresentation)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.documentation == null ? other.documentation != null : !this.documentation.equals(other.documentation)) {
            return false;
        }
        if (this.helpers == null ? other.helpers != null : !((Object)this.helpers).equals(other.helpers)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.invokeFunction == null ? other.invokeFunction != null : !this.invokeFunction.equals(other.invokeFunction)) {
            return false;
        }
        if (this.src == null ? other.src != null : !this.src.equals(other.src)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

