/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.error.filters;

import java.util.Date;
import org.jbpm.runtime.manager.impl.error.filters.AbstractExecutionErrorFilter;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorContext;
import org.kie.internal.task.exception.TaskException;

public class TaskExecutionErrorFilter
extends AbstractExecutionErrorFilter {
    public boolean accept(ExecutionErrorContext errorContext) {
        return this.isCausedBy(errorContext.getCause(), new Class[]{TaskException.class});
    }

    public ExecutionError filter(ExecutionErrorContext errorContext) {
        if (this.isCausedBy(errorContext.getCause(), new Class[]{PermissionDeniedException.class})) {
            return null;
        }
        ExecutionError.Builder taskErrorBuilder = ExecutionError.builder().type("Task");
        TaskException exception = (TaskException)this.extract(errorContext.getCause(), TaskException.class);
        String stacktrace = this.getStackTrace((Throwable)exception);
        Task task = errorContext.getLastExecutedTask();
        if (task != null) {
            taskErrorBuilder.deploymentId(task.getTaskData().getDeploymentId()).processInstanceId(Long.valueOf(task.getTaskData().getProcessInstanceId())).processId(task.getTaskData().getProcessId()).activityId(task.getId()).activityName(task.getName());
        }
        return taskErrorBuilder.message(exception.getMessage()).error(stacktrace).errorDate(new Date()).build();
    }

    public Integer getPriority() {
        return 80;
    }

    public String toString() {
        return "TaskExecutionErrorFilter [accepts=CannotAddTaskException, ignores=PermissionDeniedException]";
    }
}

