/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.env;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.pvm.PvmException;

/**
 * @author Tom Baeyens
 */
public abstract class EnvironmentHelper {
  
  static Map<Class<?>, Object> defaultObjectCache = new HashMap<Class<?>, Object>();

  public static <T> T get(Class<T> type) {
    if (type==null) {
      return null;
    }
    Environment environment = Environment.getCurrent();
    if (environment!=null) {
      return environment.get(type);  
    }
    if (defaultObjectCache.containsKey(type)) {
      return (T) defaultObjectCache.get(type);
    }
    try {
      Method defaultFactoryMethod = type.getMethod("createDefault");
      if (defaultFactoryMethod!=null) {
        Object defaultObject = defaultFactoryMethod.invoke(null);
        defaultObjectCache.put(type, defaultObject);
        return (T) defaultObject;
      }
    } catch (Exception e) {
      throw new PvmException("couldn't create default "+type.getName(), e);
    }
    return null;
  }
}
