/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.env;

import java.util.HashSet;
import java.util.Set;

import org.jbpm.pvm.internal.spring.SpringEnvironment;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/** this environment factory will see only the singleton beans.
 * 
 * The created {@link SpringEnvironment}s will see the prototype 
 * beans and it will cache them.
 *  
 * @author Tom Baeyens
 */
public class SpringEnvironmentFactory extends EnvironmentFactory implements ApplicationContextAware {
  
  // TODO pull up the common behaviour between this class and the SpringEnvironmentContext
  
  private static final long serialVersionUID = 1L;
  
  ApplicationContext applicationContext;
  
  public SpringEnvironment openEnvironment() {
    return new SpringEnvironment(this);
  }

  public boolean has(String key) {
    return applicationContext.isSingleton(key);
  }

  public Object get(String key) {
    if (has(key)) {
      return applicationContext.getBean(key);
    }
    return null;
  }

  public <T> T get(Class<T> type) {
    String name = ReflectUtil.getUnqualifiedClassName(type);
    name = name.substring(0, 1).toLowerCase() + name.substring(1);
    return (T) get(name);
  }

  public Set<String> keys() {
    HashSet<String> keys = new HashSet<String>();
    for (String key : applicationContext.getBeanDefinitionNames()) {
      if (has(key)) {
        keys.add(key);
      }
    }
    return keys;
  }
  
  public ApplicationContext getApplicationContext() {
    return applicationContext;
  }

  public void setApplicationContext(ApplicationContext applicationContext) {
    this.applicationContext = applicationContext;
  }

  
  public void close() {
  }

  public String getName() {
    return null;
  }

  public Object set(String key, Object value) {
    return null;
  }
}
