/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.hibernate;

import java.util.List;

import org.hibernate.Query;
import org.jbpm.pvm.Execution;
import org.jbpm.pvm.client.ClientExecution;
import org.jbpm.pvm.client.ClientProcessDefinition;
import org.jbpm.pvm.job.Job;
import org.jbpm.pvm.job.Message;
import org.jbpm.pvm.job.Timer;
import org.jbpm.pvm.session.PvmDbSession;

/**
 * @author Tom Baeyens
 */
public class HibernatePvmDbSession extends HibernateDbSession implements PvmDbSession {

  public HibernatePvmDbSession() {
  }

  public List<String> findProcessDefinitionNames() {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.definition.hbm.xml
    return session.getNamedQuery("findProcessDefinitionNames").list();
  }

  public List<ClientProcessDefinition> findProcessDefinitionsByName(String name) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.definition.hbm.xml
    Query query = session.getNamedQuery("findProcessDefinitionsByName");
    query.setString("name", name);
    return query.list();
  }

  public ClientProcessDefinition findProcessDefinitionByName(String name, int version) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.definition.hbm.xml
    Query query = session.getNamedQuery("findProcessDefinitionByNameAndVersion");
    query.setString("name", name);
    query.setInteger("version", version);
    ClientProcessDefinition processDefinition = (ClientProcessDefinition) query.uniqueResult();
    return processDefinition;
  }

  public ClientProcessDefinition findLatestProcessDefinitionByName(String name) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.definition.hbm.xml
    Query query = session.getNamedQuery("findProcessDefinitionsByName");
    query.setString("name", name);
    query.setMaxResults(1);
    ClientProcessDefinition processDefinition = (ClientProcessDefinition) query.uniqueResult();
    return processDefinition;
  }

  public ClientProcessDefinition findProcessDefinitionById(String processDefinitionId) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.definition.hbm.xml
    Query query = session.getNamedQuery("findProcessDefinitionsById");
    query.setString("id", processDefinitionId);
    query.setMaxResults(1);
    ClientProcessDefinition processDefinition = (ClientProcessDefinition) query.uniqueResult();
    return processDefinition;
  }

  public ClientExecution findExecutionById(String executionId) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.execution.hbm.xml
    Query query = session.getNamedQuery("findExecutionById");
    query.setString("id", executionId);
    query.setMaxResults(1);
    return (ClientExecution) query.uniqueResult();
  }

  public Execution findExecutionByKey(String processDefinitionName, String executionKey) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.execution.hbm.xml
    Query query = session.getNamedQuery("findExecutionByKey");
    query.setString("processDefinitionName", processDefinitionName);
    query.setString("executionKey", executionKey);
    query.setMaxResults(1);
    return (ClientExecution) query.uniqueResult();
  }

  public List<Timer> findTimers(int firstResult, int maxResults) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.job.hbm.xml
    Query query = session.getNamedQuery("findTimers");
    query.setFirstResult(firstResult);
    query.setMaxResults(maxResults);
    return query.list();
  }
  
  public List<Message> findMessages(int firstResult, int maxResults) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.job.hbm.xml
    Query query = session.getNamedQuery("findMessages");
    query.setFirstResult(firstResult);
    query.setMaxResults(maxResults);
    return query.list();
  }
  
  public List<Job> findJobsWithException(int firstResult, int maxResults) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.job.hbm.xml
    Query query = session.getNamedQuery("findJobsWithException");
    query.setFirstResult(firstResult);
    query.setMaxResults(maxResults);
    return query.list();
  }
}
