package org.jbpm.pvm.internal.job;

import java.io.Serializable;
import java.util.Date;

import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.job.Job;

public abstract class JobImpl<T> implements Command<T>, Serializable, Job {

  private static final long serialVersionUID = 1L;
  // private static final DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss,SSS");

  protected long dbid;
  protected int dbversion;

  /** date until which the command should not be executed
   * this date is set to the current time
   * It should be modified only for timers
   * Warning: if you modify this, be sure to wake the JobExecutor
   * when the jobImpl is supposed to be executed */
  protected Date dueDate = new Date();
  
  /** suspended jobs will not execute. */
  protected boolean isSuspended;

  /** the execution (if any) for this jobImpl */  
  protected ExecutionImpl execution;

  /** the process instance */  
  protected ExecutionImpl processInstance;
  
  // execution members

  /** specifies if this jobImpl can be executed concurrently with other jobs for the 
   * same execution. */
  protected boolean isExclusive;

  /** name of the jobImpl executor name that has locked this jobImpl. */
  protected String lockOwner;

  /** the time the lock on this jobImpl expires. */
  protected Date lockExpirationTime;

  /** stack trace of the exception that occurred during command execution. */
  protected String exception;
  
  /** number of attempts left to try.  Should be decremented each time an exception 
   * occurs during command execution. */
  protected int retries = 3;
  
  /** a command that can be used as the behaviour of this job */ 
  protected Descriptor commandDescriptor;

  public JobImpl() {
  }

  public void setExecution(ExecutionImpl execution) {
    this.execution = execution;
    this.processInstance = execution.getProcessInstance();
  }
  
  public long getDbid() {
    return dbid;
  }
  public void setDbid(long id) {
	  dbid = id;
  }
  public String getLockOwner() {
    return lockOwner;
  }
  public boolean isSuspended() {
    return isSuspended;
  }
  public Date getDueDate() {
    return dueDate;
  }
  public void setDueDate(Date dueDate) {
    this.dueDate = dueDate;
  }
  public String getException() {
    return exception;
  }
  public int getRetries() {
    return retries;
  }
  public boolean isExclusive() {
    return isExclusive;
  }
  public ExecutionImpl getExecution() {
    return execution;
  }
  public void setException(String exception) {
    this.exception = exception;
  }
  public void setExclusive(boolean isExclusive) {
    this.isExclusive = isExclusive;
  }
  public void setLockOwner(String jobExecutorName) {
    this.lockOwner = jobExecutorName;
  }
  public void setRetries(int retries) {
    this.retries = retries;
  }
  public void setSuspended(boolean isSuspended) {
    this.isSuspended = isSuspended;
  }
  public ExecutionImpl getProcessInstance() {
    return processInstance;
  }
  public Date getLockExpirationTime() {
    return lockExpirationTime;
  }
  public void setLockExpirationTime(Date lockExpirationTime) {
    this.lockExpirationTime = lockExpirationTime;
  }
  public Descriptor getCommandDescriptor() {
    return commandDescriptor;
  }
  public void setCommandDescriptor(Descriptor commandDescriptor) {
    this.commandDescriptor = commandDescriptor;
  }
}
