package org.jbpm.pvm.internal.jobexecutor;

import java.util.List;

import org.jbpm.pvm.Execution;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.session.DbSession;
import org.jbpm.pvm.session.MessageSession;

/** internal interface used by the jobImpl executor and the 
 * implementations of {@link MessageSession} and {@link TimerSession}.
 * 
 * So this session is only needed in case the {@link JobExecutor} is 
 * used to execute messages or timers.
 *  
 * @author Tom Baeyens, Pascal Verdage
 */
public interface JobDbSession extends DbSession {

  /** the jobImpl with the given id or null if none */
  public JobImpl<?> getJob(long jobId);

	/** the first jobImpl to finish among eligible and non-locked jobs or null if none */
	public JobImpl<?> findFirstAcquirableJob();

	/** the list of jobs of the process instance that mustn't be concurrent */
	public List<JobImpl<?>> findExclusiveJobs(Execution processInstance);

	/** the first jobImpl to finish among non-owned jobs or null if none */
	public JobImpl<?> findFirstDueJob();
}
