package org.jbpm.pvm.internal.lob;

import java.util.List;

import org.jbpm.pvm.env.Environment;

public class Clob {

  public static final ClobStrategy DEFAULT_CLOB_STRATEGY = new ClobStrategyChopped();

  protected java.sql.Clob clob = null;
  protected String text = null;
  protected List<String> chops = null;
  
  public Clob() {
  }

  public Clob(char[] text) {
    getClobStrategy().set(text, this);
  }

  public char[] extractChars() {
    return getClobStrategy().get(this);
  }

  protected ClobStrategy getClobStrategy() {
    ClobStrategy clobStrategy = null;
    
    Environment environment = Environment.getCurrent();
    if (environment!=null) {
      clobStrategy = environment.get(ClobStrategy.class);
    }

    if (clobStrategy==null) {
      clobStrategy = DEFAULT_CLOB_STRATEGY;
    }
    
    return clobStrategy;
  }

  public List<String> getChops() {
    return chops;
  }
  public void setChops(List<String> chops) {
    this.chops = chops;
  }
  public java.sql.Clob getClob() {
    return clob;
  }
  public void setClob(java.sql.Clob clob) {
    this.clob = clob;
  }
  public String getText() {
    return text;
  }
  public void setText(String text) {
    this.text = text;
  }
}
