package org.jbpm.pvm.internal.lob;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClobStrategyChopped implements ClobStrategy {
  
  int chopSize = 1024;
  
  public char[] get(Clob clob) {
    return glue(clob.getChops());
  }

  public void set(char[] chars, Clob clob) {
    clob.setChops(chop(chars));
  }

  public List<String> chop(char[] chars) {
    List<String> chops = null;
    if ( (chars!=null)
         && (chars.length>0) ){
      chops = new ArrayList<String>();
      int index = 0;
      while ( (chars.length-index) > chopSize ) {
        String chop = new String(chars, index, chopSize);
        chops.add(chop);
        index+=chopSize;
      }
      // add remainder chop
      String chop = new String(chars, index, chars.length-index);
      chops.add(chop);
    }
    return chops;
  }

  public char[] glue(List<String> chops) {
    if (chops!=null) {
      StringWriter writer = new StringWriter();
      
      Iterator<String> iter = chops.iterator();
      while (iter.hasNext()) {
        writer.write(iter.next());
      }
      
      return writer.toString().toCharArray();
    }

    return null;
  }
}