package org.jbpm.pvm.internal.lob;

import java.sql.SQLException;

import org.hibernate.Hibernate;
import org.jbpm.pvm.PvmException;

public class ClobStrategyClob implements ClobStrategy {

  public void set(char[] chars, Clob clob) {
    if (chars!=null) {
      clob.setClob(Hibernate.createClob(new String(chars)));
    }
  }

  public char[] get(Clob clob) {
    java.sql.Clob sqlClob = clob.getClob();
    if (sqlClob!=null) {
      try {
        int length = (int) sqlClob.length();
        String text = sqlClob.getSubString(1, length);
        return text.toCharArray();
      } catch (SQLException e) {
        throw new PvmException("couldn't extract chars out of clob", e);
      }
    } 
    return null;
  }
}
