/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.model;

import org.hibernate.Session;
import org.jbpm.pvm.Execution;
import org.jbpm.pvm.ProcessDefinition;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.model.IdGenerator;


/**
 * @author Tom Baeyens
 */
public class DefaultIdGenerator implements IdGenerator {

  public String createId(ProcessDefinition processDefinition, Execution parent, Execution execution) {

    String base = null;
    if (parent!=null) {
      base = parent.getId(); 
    } else {
      base = processDefinition.getId();
    }

    String executionPart = null;
    if (execution.getKey()!=null) {
      executionPart = execution.getKey();
    
    } else if (execution.getName()!=null) {
      executionPart = execution.getName();

    } else {
      ExecutionImpl executionImpl = (ExecutionImpl) execution;
      Session session = Environment.getFromCurrent(Session.class);
      session.save(executionImpl);
      executionPart = Long.toString(executionImpl.getDbid());
    }

    return base+"/"+executionPart;
  }

}
