/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.script;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.script.Bindings;

import org.jbpm.pvm.Execution;
import org.jbpm.pvm.env.Context;
import org.jbpm.pvm.env.Environment;


/**
 * @author Tom Baeyens
 */
public class EnvironmentBindings implements Bindings {
  
  protected String[] readContextNames;
  protected String writeContextName;
  protected Environment environment;

  public EnvironmentBindings(String[] readContextNames, String writeContextName) {
    this.readContextNames = readContextNames;
    this.writeContextName = writeContextName;
    
    environment = Environment.getCurrent();
  }

  public Object get(Object key) {
    Context context = getReadContext(key);
    if (context!=null) {
      return context.get((String) key);
    }
    return null;
  }

  protected Context getReadContext(Object key) {
    for (String readContextName: readContextNames) {
      Context readContext = environment.getContext(readContextName);
      if ( (readContext!=null)
           && (readContext.has((String) key))
         ) {
        return readContext;
      }
    }
    return null;
  }

  public boolean containsKey(Object key) {
    Context context = getReadContext(key);
    return (context!=null);
  }

  public Object put(String key, Object value) {
    if (writeContextName==null) {
      return null;
    }
    Context writeContext = environment.getContext(writeContextName);
    if (writeContext==null) {
      return null;
    }
    return writeContext.set(key, value);
  }

  public void putAll(Map< ? extends String, ? extends Object> toMerge) {
    throw new UnsupportedOperationException();
  }

  public Object remove(Object key) {
    throw new UnsupportedOperationException();
  }

  public void clear() {
    throw new UnsupportedOperationException();
  }

  public boolean containsValue(Object value) {
    throw new UnsupportedOperationException();
  }

  public Set<java.util.Map.Entry<String, Object>> entrySet() {
    throw new UnsupportedOperationException();
  }

  public boolean isEmpty() {
    throw new UnsupportedOperationException();
  }

  public Set<String> keySet() {
    throw new UnsupportedOperationException();
  }

  public int size() {
    throw new UnsupportedOperationException();
  }

  public Collection<Object> values() {
    throw new UnsupportedOperationException();
  }
}
