/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.spring;

import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.env.EnvironmentFactory;
import org.jbpm.pvm.internal.cmd.Command;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

/**
 * @author Tom Baeyens
 */
public class CommandTransactionCallback<T> implements TransactionCallback {
  
  Command<T> command;
  EnvironmentFactory environmentFactory;
  
  public CommandTransactionCallback(Command<T> command, EnvironmentFactory environmentFactory) {
    this.command = command;
    this.environmentFactory = environmentFactory;
  }

  public T doInTransaction(TransactionStatus status) {
    Environment environment = environmentFactory.openEnvironment();
    try {
      return command.execute(environment);
    } catch (Exception e) {
      throw new RuntimeException("ooops", e);
    } finally {
      environment.close();
    }
  }

}
