/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.wire.binding;

import org.jbpm.pvm.env.Transaction;
import org.jbpm.pvm.internal.tx.StandardTransaction;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

/** parses a descriptor for creating a {@link Transaction}.
 * 
 * See schema docs for more details.
 *
 * @author Tom Baeyens
 */
public class TransactionBinding extends WireDescriptorBinding {

  public TransactionBinding() {
    super("transaction");
  }

  public Object parse(Element element, Parse parse, Parser parser) {
    ObjectDescriptor transactionDescriptor = null;

    String type = "standard";
    if (element.hasAttribute("type")) {
      type = element.getAttribute("type");
    }
    
    if ("standard".equals(type)) {
      transactionDescriptor = new ObjectDescriptor(StandardTransaction.class);
    } else {
      parse.addProblem("unsupported transaction type: "+type);
    }
    
    return transactionDescriptor;
  }
}
