/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jbpm.pvm.ProcessDefinition;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.stream.ByteArrayStreamSource;
import org.jbpm.pvm.internal.stream.FileStreamSource;
import org.jbpm.pvm.internal.stream.InputStreamSource;
import org.jbpm.pvm.internal.stream.ResourceStreamSource;
import org.jbpm.pvm.internal.stream.StreamSource;
import org.jbpm.pvm.internal.stream.UrlStreamSource;
import org.jbpm.pvm.internal.util.IoUtil;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Parser parser = new Parser();
    protected String name;
    protected String language;
    protected Map<String, StreamSource> files;
    protected Map<String, Document> documents;
    protected ProcessDefinition processDefinition;

    public Deployment() {
    }

    public Deployment(ProcessDefinition processDefinition) {
        this.setProcessDefinition(processDefinition);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void addResource(String resource) {
        this.addStreamSource(resource, new ResourceStreamSource(resource));
    }

    public void addFile(File file) {
        this.addStreamSource(file.getAbsolutePath(), new FileStreamSource(file));
    }

    public void addUrl(URL url) {
        this.addStreamSource(url.toString(), new UrlStreamSource(url));
    }

    public void addInputStream(String name, InputStream inputStream) {
        this.addStreamSource(name, new InputStreamSource(inputStream));
    }

    public void addArchiveResource(String resource) {
        this.name = resource;
        ResourceStreamSource streamSource = new ResourceStreamSource(resource);
        this.addStreamSource(resource, streamSource);
    }

    public void addArchiveFile(File file) {
        this.addStreamSource(file.getAbsolutePath(), new FileStreamSource(file));
    }

    public void addArchiveUrl(URL url) {
        this.addStreamSource(url.toString(), new UrlStreamSource(url));
    }

    public void addArchive(ZipInputStream zipInputStream) {
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                byte[] bytes = IoUtil.readBytes(zipInputStream);
                if (bytes != null) {
                    this.addStreamSource(entryName, new ByteArrayStreamSource(bytes));
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new PvmException("couldn't read zip archive", e);
        }
    }

    public void addDirectory(String directory) {
        if (directory == null) {
            throw new PvmException("directory is null");
        }
        this.addDirectory(new File(directory), "", false);
    }

    public void addDirectoryCanonical(String directory) {
        if (directory == null) {
            throw new PvmException("directory is null");
        }
        this.addDirectory(new File(directory), "", true);
    }

    public void addDirectory(File directory) {
        this.addDirectory(directory, "", false);
    }

    public void addDirectoryCanonical(File directory) {
        this.addDirectory(directory, "", true);
    }

    protected void addDirectory(File directory, String relativeDirectoryName, boolean canonicalPathNames) {
        if (directory == null) {
            throw new PvmException("directory is null");
        }
        if (!directory.isDirectory()) {
            throw new PvmException(directory.getAbsolutePath() + " is not a directory");
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                String relativeFileName;
                String string = relativeFileName = canonicalPathNames ? null : relativeDirectoryName + "/" + file.getName();
                if (file.isFile()) {
                    if (canonicalPathNames) {
                        try {
                            this.addStreamSource(file.getCanonicalPath(), new FileStreamSource(file));
                            continue;
                        }
                        catch (IOException e) {
                            throw new PvmException("can't get canonical path name for " + file);
                        }
                    }
                    this.addStreamSource(relativeFileName, new FileStreamSource(file));
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.addDirectory(file, relativeFileName, canonicalPathNames);
            }
        }
    }

    protected void addStreamSource(String name, StreamSource streamSource) {
        if (this.name == null) {
            this.name = name;
        }
        if (this.files == null) {
            this.files = new HashMap<String, StreamSource>();
        }
        this.files.put(name, streamSource);
    }

    public InputStream getFile(String name) {
        if (this.files == null) {
            return null;
        }
        StreamSource streamSource = this.files.get(name);
        return streamSource != null ? streamSource.openStream() : null;
    }

    public Set<String> getFileNames() {
        if (this.files == null) {
            return Collections.EMPTY_SET;
        }
        return this.files.keySet();
    }

    public Document getDocument(String name) {
        if (this.documents != null && this.documents.containsKey(name)) {
            return this.documents.get(name);
        }
        if (this.files != null && this.files.containsKey(name)) {
            InputStream fileStream = this.getFile(name);
            return parser.createParse().setInputStream(fileStream).execute().checkProblems("deployment file " + name).getDocument();
        }
        return null;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        if (this.language == null) {
            this.language = "api";
        }
        this.processDefinition = processDefinition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

