/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.pvm.Deployment;
import org.jbpm.pvm.ProcessDefinition;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.deploy.DeployerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployCmd
implements Command<ProcessDefinition> {
    private static final long serialVersionUID = 1L;
    protected Deployment deployment;

    public DeployCmd(Deployment deployment) {
        this.deployment = deployment;
    }

    @Override
    public ProcessDefinition execute(Environment environment) throws Exception {
        ProcessDefinition processDefinition = this.deployment.getProcessDefinition();
        if (processDefinition != null) {
            DeployerManager deployerManager = environment.get(DeployerManager.class);
            if (deployerManager == null) {
                throw new PvmException("no " + DeployerManager.class.getName() + " configured");
            }
            deployerManager.deploy(this.deployment);
        }
        return processDefinition;
    }
}

