/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.client.ClientExecution;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.session.PvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetVariablesCmd
implements Command<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected List<String> variableNames;

    public GetVariablesCmd(String executionId, List<String> variableNames) {
        if (executionId == null) {
            throw new PvmException("executionId is null");
        }
        this.executionId = executionId;
        if (variableNames == null) {
            throw new PvmException("variableNames is null");
        }
        this.variableNames = variableNames;
    }

    @Override
    public Map<String, Object> execute(Environment environment) throws Exception {
        PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);
        ClientExecution execution = pvmDbSession.findExecutionById(this.executionId);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (String variableName : this.variableNames) {
            Object value = execution.getVariable(variableName);
            variables.put(variableName, value);
        }
        return variables;
    }
}

