/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.Map;
import org.jbpm.pvm.Execution;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.client.ClientProcessDefinition;
import org.jbpm.pvm.client.ClientProcessInstance;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.cmd.VariablesCmd;
import org.jbpm.pvm.session.PvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartExecutionInLatestCmd
extends VariablesCmd<Execution> {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionName;
    protected String executionKey;

    public StartExecutionInLatestCmd(String processDefinitionName, Map<String, Object> variables, String executionKey) {
        this.processDefinitionName = processDefinitionName;
        this.variables = variables;
        this.executionKey = executionKey;
    }

    @Override
    public Execution execute(Environment environment) throws Exception {
        PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);
        ClientProcessDefinition processDefinition = null;
        processDefinition = pvmDbSession.findLatestProcessDefinitionByName(this.processDefinitionName);
        if (processDefinition == null) {
            throw new PvmException("no process definition with name '" + this.processDefinitionName + "'");
        }
        ClientProcessInstance processInstance = processDefinition.createProcessInstance(this.executionKey);
        processInstance.setVariables(this.variables);
        processInstance.begin();
        pvmDbSession.save(processInstance);
        return processInstance;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processName) {
        this.processDefinitionName = processName;
    }

    public String getExecutionKey() {
        return this.executionKey;
    }

    public void setExecutionKey(String executionKey) {
        this.executionKey = executionKey;
    }
}

