/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.deploy;

import org.jbpm.pvm.Deployment;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.deploy.Deployer;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;

public class CreateId
implements Deployer {
    private static final Log log = Log.getLog(CreateId.class.getName());

    public void deploy(Deployment deployment) {
        ProcessDefinitionImpl processDefinition = (ProcessDefinitionImpl)deployment.getProcessDefinition();
        if (processDefinition.getId() == null) {
            String key = processDefinition.getKey();
            if (key == null) {
                key = processDefinition.getName();
            }
            if ("".equals(key)) {
                throw new PvmException("empty string is not a valid key");
            }
            key = key.replaceAll("\\W", "_");
            String id = key + ":" + processDefinition.getVersion();
            log.trace("created id '" + id + "' for " + processDefinition);
            processDefinition.setId(id);
        }
    }
}

