/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.ejb;

import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.ejb.LocalCommandExecutor;
import org.jbpm.pvm.internal.ejb.LocalCommandExecutorHome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseLocalCommandService
implements CommandService {
    private LocalCommandExecutor commandExecutor;

    public LocalCommandExecutor getCommandExecutor() {
        if (this.commandExecutor == null) {
            try {
                InitialContext context = new InitialContext();
                LocalCommandExecutorHome commandExecutorHome = (LocalCommandExecutorHome)context.lookup("java:comp/env/ejb/LocalCommandExecutor");
                context.close();
                this.commandExecutor = commandExecutorHome.create();
            }
            catch (NamingException e) {
                throw new PvmException("error retrieving command executor home", e);
            }
            catch (CreateException e) {
                throw new PvmException("error creating command executor", e);
            }
        }
        return this.commandExecutor;
    }

    @Override
    public <T> T execute(Command<T> command) {
        return this.getCommandExecutor().execute(command);
    }
}

