/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.ejb;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.ejb.LocalTimer;
import org.jbpm.pvm.internal.ejb.LocalTimerHome;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.job.Timer;
import org.jbpm.pvm.session.DbSession;
import org.jbpm.pvm.session.TimerSession;

public class EnterpriseTimerSession
implements TimerSession {
    private LocalTimerHome timerHome;
    private static final Log log = Log.getLog(EnterpriseTimerSession.class.getName());

    public void schedule(Timer timer) {
        log.debug("scheduling " + timer);
        DbSession dbSession = Environment.getCurrent().get(DbSession.class);
        dbSession.save(timer);
        dbSession.flush();
        try {
            LocalTimer timerBean = this.timerHome.findByPrimaryKey(timer.getDbid());
            timerBean.schedule();
        }
        catch (FinderException e) {
            throw new PvmException("could not find bean for timer: " + timer);
        }
    }

    public void cancel(Timer timer) {
        try {
            LocalTimer timerBean = this.timerHome.findByPrimaryKey(timer.getDbid());
            log.debug("canceling " + timer);
            timerBean.remove();
        }
        catch (FinderException e) {
            log.error("could not find bean for timer " + timer, e);
        }
        catch (RemoveException e) {
            log.error("could not remove bean for timer " + timer, e);
        }
    }
}

