/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.ejb;

import java.util.Date;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.job.TimerImpl;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteTimerCmd
implements Command<Date> {
    private final long timerDbid;
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog(ExecuteTimerCmd.class.getName());

    public ExecuteTimerCmd(long timerDbid) {
        this.timerDbid = timerDbid;
    }

    @Override
    public Date execute(Environment environment) throws Exception {
        DbSession dbSession = environment.get(DbSession.class);
        TimerImpl timerImpl = dbSession.get(TimerImpl.class, this.timerDbid);
        if (timerImpl == null) {
            log.debug("timer not found: " + this.timerDbid);
            return null;
        }
        return timerImpl.execute(environment) != false ? null : timerImpl.getDueDate();
    }

    public String toString() {
        return ExecuteTimerCmd.class.getSimpleName() + '(' + this.timerDbid + ')';
    }
}

