/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.util.Date;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.env.Transaction;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.jobexecutor.JobDbSession;
import org.jbpm.pvm.internal.jobexecutor.JobExceptionHandler;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.job.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteJobCmd
implements Command<Job> {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog(ExecuteJobCmd.class.getName());
    protected long jobDbid;

    public ExecuteJobCmd(long jobDbid) {
        this.jobDbid = jobDbid;
    }

    @Override
    public Job execute(Environment environment) throws Exception {
        JobImpl job;
        block6: {
            JobDbSession session = environment.get(JobDbSession.class);
            if (session == null) {
                throw new PvmException("no job session configured to get job " + this.jobDbid + " for execution");
            }
            job = session.get(JobImpl.class, this.jobDbid);
            if (job != null) {
                try {
                    log.debug("executing job " + job + "...");
                    job.execute(environment);
                    log.debug("executed job " + job);
                    Date lockExpirationDate = job.getLockExpirationTime();
                    if (lockExpirationDate == null) break block6;
                    long lockExpiration = lockExpirationDate.getTime();
                    long currentTime = System.currentTimeMillis();
                    if (currentTime > lockExpiration) {
                        throw new PvmException("job took too long: lock expired " + (currentTime - lockExpiration) + "ms ago");
                    }
                }
                catch (Throwable exception) {
                    log.error("exception while executing '" + job + "'", exception);
                    this.handleJobExecutionException(environment, job, exception);
                }
            } else {
                log.debug("job " + this.jobDbid + " no longer exists");
            }
        }
        return job;
    }

    protected void handleJobExecutionException(Environment environment, JobImpl<?> job, Throwable exception) {
        Transaction transaction = environment.get(Transaction.class);
        transaction.setRollbackOnly();
        CommandService commandService = environment.get(CommandService.class);
        JobExceptionHandler jobExceptionHandler = new JobExceptionHandler(job.getDbid(), exception, commandService);
        transaction.registerSynchronization(jobExceptionHandler);
    }
}

