/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.jobexecutor.ExecuteJobCmd;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.log.Log;

public class JobExecutorThread
extends Thread {
    private static final Log log = Log.getLog(JobExecutorThread.class.getName());
    JobExecutor jobExecutor;
    boolean isActive = true;

    public JobExecutorThread(String name, JobExecutor jobExecutor) {
        super(name);
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info("starting...");
        try {
            BlockingQueue<Collection<Long>> queue = this.jobExecutor.getJobDbidsQueue();
            if (queue == null) {
                log.debug("no queue to take jobs from");
            } else {
                while (this.isActive) {
                    try {
                        log.trace("taking jobs from queue");
                        Collection<Long> jobDbids = null;
                        jobDbids = queue.take();
                        log.debug("took job(s) " + jobDbids + " from queue");
                        for (Long jobDbid : jobDbids) {
                            CommandService commandService = this.jobExecutor.getCommandExecutor();
                            commandService.execute(new ExecuteJobCmd(jobDbid));
                        }
                    }
                    catch (InterruptedException e) {
                        log.trace("waiting for acquired jobs got interrupted");
                    }
                    catch (Exception e) {
                        log.error("exception in job executor thread", e);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            log.info(this.getName() + " leaves cyberspace");
        }
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean join) {
        if (this.isActive) {
            log.trace("deactivating " + this.getName());
            this.isActive = false;
            this.interrupt();
            if (join) {
                while (this.isAlive()) {
                    try {
                        this.join();
                    }
                    catch (InterruptedException e) {
                        log.trace("joining " + this.getName() + " got interrupted");
                    }
                }
            }
        } else {
            log.trace("ignoring deactivate: " + this.getName() + " is not active");
        }
    }
}

