/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.env.Transaction;
import org.jbpm.pvm.internal.jobexecutor.JobAddedNotification;
import org.jbpm.pvm.internal.jobexecutor.JobDbSession;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.job.Timer;
import org.jbpm.pvm.session.TimerSession;

public class JobExecutorTimerSession
implements TimerSession {
    private static final Log log = Log.getLog(TimerSession.class.getName());
    Transaction transaction;
    JobExecutor jobExecutor;
    JobDbSession jobDbSession;
    boolean jobExecutorNotificationScheduled = false;

    public void schedule(Timer timer) {
        log.debug("scheduling " + timer);
        this.validate(timer);
        this.jobDbSession.save(timer);
        if (!this.jobExecutorNotificationScheduled) {
            this.jobExecutorNotificationScheduled = true;
            this.transaction.registerSynchronization(new JobAddedNotification(this.jobExecutor));
        }
    }

    protected void validate(Timer timer) {
        if (timer == null) {
            throw new PvmException("null timer scheduled");
        }
        if (timer.getExecution() == null) {
            throw new PvmException("timer has no execution specified");
        }
        if (timer.getSignalName() == null && timer.getEventName() == null) {
            throw new PvmException("timer has no signalName or eventName specified");
        }
        if (timer.getDueDate() == null) {
            throw new PvmException("timer scheduled at null date");
        }
        if (timer.getDueDate().getTime() < 0L) {
            throw new PvmException("timer scheduled with a negative date");
        }
    }

    public void cancel(Timer timer) {
        log.debug("canceling " + timer);
        if (timer == null) {
            throw new PvmException("timer is null");
        }
        this.jobDbSession.delete(timer);
    }
}

