/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.log.Jdk14Log;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.log.LogFactory;

public class Jdk14LogFactory
implements LogFactory {
    public Jdk14LogFactory() {
        Jdk14LogFactory.initializeJdk14Logging();
    }

    public Log getLog(String name) {
        return new Jdk14Log(Logger.getLogger(name));
    }

    public static synchronized void redirectCommonsToJdk14() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }

    public static synchronized void initializeJdk14Logging() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("logging.properties");
        try {
            String redirectCommons;
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
            }
            if (!((redirectCommons = LogManager.getLogManager().getProperty("redirect.commons.logging")) == null || redirectCommons.equalsIgnoreCase("disabled") || redirectCommons.equalsIgnoreCase("off") || redirectCommons.equalsIgnoreCase("false"))) {
                Jdk14LogFactory.redirectCommonsToJdk14();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PvmException("couldn't initialize logging properly", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

